/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.handler.goals;

import com.mrbysco.angrymobs.config.AngryConfig;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class MobMeleeAttackGoal
extends Goal {
    protected final Mob attacker;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int delayCounter;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private final float attackDamage;
    private final float knockback;

    public MobMeleeAttackGoal(Mob creature, double speedIn, float damage, float knockback, boolean useLongMemory) {
        this.attacker = creature;
        this.speedTowardsTarget = speedIn;
        this.attackDamage = damage;
        this.knockback = knockback;
        this.longMemory = useLongMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public MobMeleeAttackGoal(Mob creature, double speedIn, float damage, boolean useLongMemory) {
        this(creature, speedIn, damage, 0.0f, useLongMemory);
    }

    public boolean m_8036_() {
        long i = this.attacker.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.attacker.m_6710_((LivingEntity)null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity != null) {
            this.attacker.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            this.delayCounter = Math.max(this.delayCounter - 1, 0);
            if ((this.longMemory || this.attacker.m_21574_().m_148306_((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
                this.targetX = livingentity.m_20185_();
                this.targetY = livingentity.m_20186_();
                this.targetZ = livingentity.m_20189_();
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.m_21573_().m_26570_() != null ? ((finalPathPoint = this.attacker.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.m_21573_().m_5624_((Entity)livingentity, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.isTimeToAttack()) {
            this.resetAttackCooldown();
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.doHurtTarget((Entity)enemy);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag;
        int i;
        float f = this.attackDamage;
        float f1 = this.knockback;
        if (((Boolean)AngryConfig.COMMON.useAttributes.get()).booleanValue()) {
            if (this.attacker.m_21204_().m_22171_(Attributes.f_22281_)) {
                f += (float)this.attacker.m_21204_().m_22181_(Attributes.f_22281_);
            }
            if (this.attacker.m_21204_().m_22171_(Attributes.f_22278_)) {
                f1 += (float)this.attacker.m_21204_().m_22181_(Attributes.f_22278_);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.attacker.m_21205_(), (MobType)livingEntity.m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this.attacker);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this.attacker)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(this.attacker.m_269291_().m_269333_((LivingEntity)this.attacker), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.attacker.m_146908_() * ((float)Math.PI / 180)))));
                this.attacker.m_20256_(this.attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.maybeDisableShield(player, this.attacker.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.attacker.m_19970_((LivingEntity)this.attacker, entity);
            this.attacker.m_21335_(entity);
        }
        return flag;
    }

    private void maybeDisableShield(Player player, ItemStack mobItemStack, ItemStack playerItemStack) {
        if (!mobItemStack.m_41619_() && !playerItemStack.m_41619_() && mobItemStack.m_41720_() instanceof AxeItem && playerItemStack.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this.attacker) * 0.05f;
            if (this.attacker.m_217043_().m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.attacker.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return 20;
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

