/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.handler;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.config.attributes.AttributeConfigHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeHandler {
    private static Map<ResourceLocation, Attribute> cachedAttributeMap = new HashMap<ResourceLocation, Attribute>();

    public static void addEntityAttributes(EntityAttributeModificationEvent event) {
        AttributeConfigHandler.loadConfig();
        if (AttributeConfigHandler.additionMap.isEmpty()) {
            return;
        }
        cachedAttributeMap.clear();
        for (EntityType entityType : event.getTypes()) {
            AttributeConfigHandler.AdditionValues values;
            ResourceLocation entityLocation = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            if (entityLocation == null || (values = (AttributeConfigHandler.AdditionValues)AttributeConfigHandler.additionMap.getOrDefault(entityLocation.toString(), null)) == null) continue;
            ResourceLocation attributeLocation = ResourceLocation.m_135820_((String)values.attribute());
            if (attributeLocation != null) {
                Attribute attribute = cachedAttributeMap.getOrDefault(attributeLocation, (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeLocation));
                if (attribute != null) {
                    if (!cachedAttributeMap.containsKey(attributeLocation)) {
                        cachedAttributeMap.put(attributeLocation, attribute);
                    }
                    if (!event.has(entityType, attribute)) {
                        AngryMobs.LOGGER.info("Adding attribute: {} with value: {} to entity: {}", new Object[]{attributeLocation, values.value(), entityLocation});
                        event.add(entityType, attribute, values.value());
                        continue;
                    }
                    AngryMobs.LOGGER.error("Attribute: {} already exists for entity: {}, ignoring entry!", (Object)attributeLocation, (Object)entityLocation);
                    continue;
                }
                AngryMobs.LOGGER.error("Attribute: {} does not exist!", (Object)attributeLocation);
                continue;
            }
            AngryMobs.LOGGER.error("Attribute location {} doesn't match the format: modid:attribute_name", (Object)values.attribute());
        }
        cachedAttributeMap.clear();
    }
}

