/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.config;

import com.mrbysco.angrymobs.AngryMobs;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class AngryConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        AngryMobs.LOGGER.debug("Loaded Angry Mobs' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        AngryMobs.LOGGER.warn("Angry Mobs' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue angryAnimals;
        public final ForgeConfigSpec.BooleanValue angryReinforcements;
        public final ForgeConfigSpec.BooleanValue aggressiveAnimals;
        public final ForgeConfigSpec.BooleanValue useAttributes;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common settings").push("Common");
            this.angryAnimals = builder.comment("When true makes all vanilla animals attack you if you hurt them").define("angryAnimals", false);
            this.angryReinforcements = builder.comment("When true makes all vanilla animals call for reinforcement when you hurt them").define("angryReinforcements", false);
            this.aggressiveAnimals = builder.comment("When true makes all vanilla animals attack you on sight").define("aggressiveAnimals", false);
            this.useAttributes = builder.comment("When true makes the melee goals add the mobs attack damage and knockback onto the specified values").define("useAttributes", true);
            builder.pop();
        }
    }
}

