/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlockEntity;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HeadstockBlock
extends HorizontalDirectionalBlock
implements IBE<HeadstockBlockEntity>,
IWrenchable,
ProperWaterloggedBlock,
BlockStateBlockItemGroup.GroupedBlock {
    public static final EnumProperty<HeadstockStyle> STYLE = EnumProperty.m_61587_((String)"style", HeadstockStyle.class);
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.m_61465_((String)"upside_down");

    public HeadstockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STYLE, (Comparable)((Object)HeadstockStyle.BUFFER))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, STYLE, UPSIDE_DOWN}));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            if (context.m_43719_().m_122434_().m_122478_()) {
                state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
            } else {
                state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_43719_());
                if (context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() < 0.5) {
                    state = (BlockState)state.m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return this.withWater(state, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        VoxelShape shape = (switch ((HeadstockStyle)((Object)state.m_61143_(STYLE))) {
            default -> throw new IncompatibleClassChangeError();
            case HeadstockStyle.PLAIN -> CRShapes.HEADSTOCK_PLAIN;
            case HeadstockStyle.BUFFER -> CRShapes.HEADSTOCK_BUFFER;
            case HeadstockStyle.LINK, HeadstockStyle.LINKLESS -> CRShapes.HEADSTOCK_LINK_PIN;
            case HeadstockStyle.KNUCKLE, HeadstockStyle.KNUCKLE_SPLIT -> CRShapes.HEADSTOCK_KNUCKLE;
            case HeadstockStyle.SCREWLINK -> CRShapes.HEADSTOCK_SCREWLINK;
        }).get(dir);
        if (((Boolean)state.m_61143_((Property)UPSIDE_DOWN)).booleanValue()) {
            AABB toErase = (AABB)CRShapes.HEADSTOCK_PLAIN.get(dir).m_83299_().get(0);
            return new AllShapes.Builder(shape).erase(toErase.f_82288_ * 16.0, toErase.f_82289_ * 16.0, toErase.f_82290_ * 16.0, toErase.f_82291_ * 16.0, toErase.f_82292_ * 16.0, toErase.f_82293_ * 16.0).add(CRShapes.HEADSTOCK_PLAIN.get(dir).m_83216_(0.0, -0.25, 0.0)).build();
        }
        return shape;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return InteractionResult.PASS;
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyMaterialIfValid(pPlayer.m_21120_(pHand)));
        if (result.m_19077_()) {
            return result;
        }
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyDyeIfValid(pPlayer.m_21120_(pHand)));
    }

    public Class<HeadstockBlockEntity> getBlockEntityClass() {
        return HeadstockBlockEntity.class;
    }

    public BlockEntityType<? extends HeadstockBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.HEADSTOCK.get();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return CRBlocks.HEADSTOCK_GROUP.get((HeadstockStyle)((Object)state.m_61143_(STYLE))).asStack();
    }
}

