/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import tcintegrations.util.ResourceLocationHelper;

public class ModerateModifier
extends NoLevelsModifier
implements BreakSpeedModifierHook,
TooltipModifierHook {
    private static final float BASELINE_TEMPERATURE = 1.0f;
    private static final float MAX_BOOST = 7.5f;
    private static final Component MINING_SPEED = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("moderate.mining_speed")));

    private static float getBonus(Player player, BlockPos pos) {
        float biomeTemp = ((Biome)player.m_9236_().m_204166_(pos).m_203334_()).m_47528_(pos);
        return 7.5f - Math.abs(1.0f - biomeTemp) * 4.4f;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP);
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + ModerateModifier.getBonus(event.getEntity(), (BlockPos)event.getPosition().get()) * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float bonus;
        if (tool.hasTag(TinkerTags.Items.HARVEST) && (bonus = player != null && tooltipKey == TooltipKey.SHIFT ? ModerateModifier.getBonus(player, player.m_20183_()) : 7.5f) > 0.01f) {
            TooltipModifierHook.addFlatBoost((Modifier)modifier.getModifier(), (Component)MINING_SPEED, (double)(bonus * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED)), tooltip);
        }
    }
}

