/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.Tags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipeCache;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import tcintegrations.TCIntegrations;
import tcintegrations.common.TagManager;
import tcintegrations.items.modifiers.traits.ManaModifier;
import tcintegrations.util.BotaniaHelper;

public class ElementalModifier
extends ManaModifier
implements MeleeHitModifierHook,
ProcessLootModifierHook {
    private static final int MANA_PER_DAMAGE = 70;

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.PROCESS_LOOT);
    }

    @Override
    public int getManaPerDamage(ServerPlayer player) {
        return BotaniaHelper.getManaPerDamageBonus((Player)player, 70);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player;
        Player player2 = player = context.getPlayerAttacker() != null ? context.getPlayerAttacker() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            ItemStack stack = sp.m_21120_(InteractionHand.MAIN_HAND);
            if (TCIntegrations.RANDOM.nextFloat() <= 0.05f) {
                BotaniaHelper.spawnPixie(sp, stack, context.getLivingTarget());
            }
        }
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        List recipes;
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && !entity.m_9236_().f_46443_ && entity.m_6095_().m_204039_(TagManager.EntityTypes.ELEMENTAL_SEVERING_MOBS) && generatedLoot.stream().noneMatch(stack -> stack.m_204117_(Tags.Items.HEADS)) && !(recipes = SeveringRecipeCache.findRecipe((RecipeManager)context.m_78952_().m_7465_(), (EntityType)entity.m_6095_())).isEmpty()) {
            float chance = 0.0769f;
            EntityType entityType = entity.m_6095_();
            if (entityType == EntityType.f_20524_ || entityType == EntityType.f_20497_) {
                chance = 0.1154f;
            }
            for (SeveringRecipe recipe : recipes) {
                ItemStack result = recipe.getOutput(entity);
                if (result.m_41619_() || !(TCIntegrations.RANDOM.nextFloat() <= chance)) continue;
                if (result.m_41613_() > 1) {
                    result.m_41764_(TCIntegrations.RANDOM.nextInt(result.m_41613_()) + 1);
                }
                generatedLoot.add(result);
            }
        }
    }
}

