/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon;

import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.data.ICommonRecipeHelper;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import tcintegrations.data.BaseRecipeProvider;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.items.TCIntegrationsItems;
import tcintegrations.util.ResourceLocationHelper;

public class SmelteryRecipeProvider
extends BaseRecipeProvider
implements ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public SmelteryRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public String m_6055_() {
        return "TCIntegrations - Smeltery Recipes";
    }

    @Override
    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.addMeltingRecipes(consumer);
        this.addAlloyRecipes(consumer);
    }

    private void addMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/melting/";
        String metalFolder = folder + "metal/";
        Consumer botaniaConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")});
        Consumer aquacultureConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")});
        Consumer malumConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")});
        Consumer undergardenConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("undergarden")});
        Consumer adAstraConsumer = this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.modLoaded("ad_astra"), this.modLoaded("beyond_earth")})});
        Consumer ifdConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("iceandfire")});
        Consumer arsConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("ars_nouveau")});
        this.molten(arsConsumer, (FluidObject)TCIntegrationsItems.MOLTEN_SOURCE_GEM).smallGem();
        this.metal(botaniaConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_MANASTEEL).metal();
        this.metal(aquacultureConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_NEPTUNIUM).metal();
        this.metal(malumConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL).metal();
        this.metal(undergardenConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_CLOGGRUM).ore(new IByproduct[0]).metal();
        this.metal(undergardenConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_FROSTSTEEL).ore(new IByproduct[0]).metal();
        this.metal(undergardenConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_FORGOTTEN_METAL).metal();
        this.metal(adAstraConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_DESH).ore(new IByproduct[0]).metal();
        this.metal(adAstraConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_CALORITE).ore(new IByproduct[0]).metal();
        this.metal(adAstraConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_OSTRUM).ore(new IByproduct[0]).metal();
        this.metalWithoutNugget(ifdConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE);
        this.metalWithoutNugget(ifdConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE);
        this.metalWithoutNugget(ifdConsumer, (FluidObject<?>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_HELMET}), (Fluid)TinkerFluids.moltenSilver.get(), (int)450).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_CHESTPLATE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)720).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_LEGGINGS}), (Fluid)TinkerFluids.moltenSilver.get(), (int)630).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_BOOTS}), (Fluid)TinkerFluids.moltenSilver.get(), (int)360).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_AXE, ModIntegration.IFD_SILVER_PICKAXE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)270).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/axes"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_SWORD, ModIntegration.IFD_SILVER_HOE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)180).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/weapon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_SHOVEL}), (Fluid)TinkerFluids.moltenSilver.get(), (int)90).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/small"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_HEAD, ModIntegration.IFD_DRAGONARMOR_SILVER_NECK}), (Fluid)TinkerFluids.moltenSilver.get(), (int)4050).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/dragon_armor_head_neck"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_BODY}), (Fluid)TinkerFluids.moltenSilver.get(), (int)6480).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/dragon_armor_head_body"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_TAIL}), (Fluid)TinkerFluids.moltenSilver.get(), (int)2430).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "silver/dragon_armor_head_tail"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_HELMET}), (Fluid)TinkerFluids.moltenCopper.get(), (int)450).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_CHESTPLATE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)720).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_LEGGINGS}), (Fluid)TinkerFluids.moltenCopper.get(), (int)630).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_BOOTS}), (Fluid)TinkerFluids.moltenCopper.get(), (int)360).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_AXE, ModIntegration.IFD_COPPER_PICKAXE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)270).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/axes"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_SWORD, ModIntegration.IFD_COPPER_HOE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)180).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/weapon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_SHOVEL}), (Fluid)TinkerFluids.moltenCopper.get(), (int)90).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/small"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_HEAD, ModIntegration.IFD_DRAGONARMOR_COPPER_NECK}), (Fluid)TinkerFluids.moltenCopper.get(), (int)4050).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/dragon_armor_head_neck"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_BODY}), (Fluid)TinkerFluids.moltenCopper.get(), (int)6480).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/dragon_armor_head_body"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_TAIL}), (Fluid)TinkerFluids.moltenCopper.get(), (int)2430).setDamagable(new int[]{10}).save(ifdConsumer, this.location(metalFolder + "copper/dragon_armor_head_tail"));
    }

    private void addAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/alloys/";
        Consumer wrapped = this.withCondition(consumer, new ICondition[]{new TagEmptyCondition(ResourceLocationHelper.location("forge", "ingots/tin"))});
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenBronze.get(), (int)360).addInput(TinkerFluids.moltenCopper.ingredient(270)).addInput(TinkerFluids.moltenObsidian.ingredient(1000)).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenBronze, folder));
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, String name, TagKey<Fluid> fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(name), fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        return this.molten(consumer, fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    private void metalWithoutNugget(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        SmelteryRecipeBuilder builder = this.molten(consumer, fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
        ResourceLocation name = this.location(fluid.getId().m_135815_().substring("molten_".length()));
        builder.oreRate(IMeltingContainer.OreRateType.METAL);
        builder.baseUnit(90);
        builder.damageUnit(10);
        builder.melting(9.0f, "block", "storage_blocks", 3.0f, false, false);
        this.basinMetalCasting(builder, consumer, fluid, name);
        builder.meltingCasting(1.0f, TinkerSmeltery.ingotCast, 1.0f, false);
    }

    private void basinMetalCasting(SmelteryRecipeBuilder builder, Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ResourceLocation name) {
        String castingFolder = "smeltery/casting/metal/";
        String tagName = "storage_blocks/" + name.m_135815_();
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ItemOutput.fromTag((TagKey)SmelteryRecipeBuilder.itemTag((String)tagName))).setFluid(fluid.ingredient(810)).setCoolingTime(IMeltingRecipe.getTemperature(fluid), 810).save(consumer, this.location(name, castingFolder, "block"));
    }

    private ResourceLocation location(ResourceLocation name, String folder, String variant) {
        return name.m_247449_(folder + name.m_135815_() + "/" + variant);
    }
}

