/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class FurnaceHandler<R extends IESerializableRecipe> {
    private int process = 0;
    private int processMax = 0;
    private int burnTime = 0;
    private int lastBurnTime = 0;
    public final StateView stateView = new StateView();
    private final int fuelSlot;
    private final List<InputSlot<R>> inputs;
    private final List<OutputSlot<R>> outputs;
    private final ToIntFunction<R> getProcessingTime;
    private final Runnable setChanged;

    public FurnaceHandler(int fuelSlot, List<InputSlot<R>> inputs, List<OutputSlot<R>> outputs, ToIntFunction<R> getProcessingTime, Runnable setChanged) {
        this.fuelSlot = fuelSlot;
        this.inputs = inputs;
        this.outputs = outputs;
        this.getProcessingTime = getProcessingTime;
        this.setChanged = setChanged;
    }

    public boolean tickServer(IMultiblockContext<? extends IFurnaceEnvironment<R>> ctx) {
        boolean active = false;
        IFurnaceEnvironment<R> env = ctx.getState();
        if (this.burnTime > 0) {
            R recipe;
            int processSpeed = 1;
            if (this.process > 0) {
                processSpeed = env.getProcessSpeed(ctx.getLevel());
            }
            this.burnTime -= processSpeed;
            if (this.process > 0) {
                if (this.isAnyInputEmpty((IItemHandler)env.getInventory())) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe(env);
                    if (recipe != null && this.getProcessTime(recipe) != this.processMax) {
                        this.processMax = 0;
                        this.process = 0;
                    } else {
                        this.process -= processSpeed;
                        processSpeed = 0;
                        active = true;
                    }
                }
                this.setChanged.run();
            }
            if (this.process <= 0) {
                if (this.processMax > 0) {
                    this.doRecipeIO(env);
                    this.processMax = 0;
                    this.burnTime -= this.process;
                }
                if ((recipe = this.getRecipe(env)) != null) {
                    int time = this.getProcessTime(recipe);
                    this.process = time - processSpeed;
                    this.processMax = time;
                    active = true;
                }
            }
        }
        if (this.burnTime <= 0 && this.getRecipe(env) != null) {
            IItemHandlerModifiable inv = env.getInventory();
            ItemStack fuel = inv.getStackInSlot(this.fuelSlot);
            int addedBurntime = env.getBurnTimeOf(ctx.getLevel().getRawLevel(), fuel);
            if (addedBurntime > 0) {
                this.lastBurnTime = addedBurntime;
                this.burnTime += this.lastBurnTime;
                if (fuel.hasCraftingRemainingItem() && fuel.m_41613_() == 1) {
                    inv.setStackInSlot(this.fuelSlot, fuel.getCraftingRemainingItem());
                } else {
                    fuel.m_41774_(1);
                }
                this.setChanged.run();
            }
        }
        if (!active) {
            env.turnOff(ctx.getLevel());
        }
        return active;
    }

    public Tag toNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128405_("process", this.process);
        result.m_128405_("processMax", this.processMax);
        result.m_128405_("burnTime", this.burnTime);
        result.m_128405_("lastBurnTime", this.lastBurnTime);
        return result;
    }

    public void readNBT(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)nbt;
        this.process = compound.m_128451_("process");
        this.processMax = compound.m_128451_("processMax");
        this.burnTime = compound.m_128451_("burnTime");
        this.lastBurnTime = compound.m_128451_("lastBurnTime");
    }

    private boolean isAnyInputEmpty(IItemHandler inv) {
        for (InputSlot<R> i : this.inputs) {
            if (!inv.getStackInSlot(i.slotIndex).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private R getRecipe(IFurnaceEnvironment<R> env) {
        R recipe = env.getRecipeForInput();
        if (recipe == null) {
            return null;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (OutputSlot<R> out : this.outputs) {
            ItemStack currentStack = inv.getStackInSlot(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= inv.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    private void doRecipeIO(IFurnaceEnvironment<R> env) {
        R recipe = this.getRecipe(env);
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (InputSlot<R> inputSlot : this.inputs) {
            int reqSize = this.inputs.stream().map(matchSlot -> matchSlot.get(recipe)).filter(ingr -> ingr.test(inv.getStackInSlot(slot.slotIndex))).mapToInt(IngredientWithSize::getCount).findFirst().orElse(0);
            inv.getStackInSlot(inputSlot.slotIndex).m_41774_(reqSize);
        }
        for (OutputSlot outputSlot : this.outputs) {
            ItemStack result = outputSlot.get(recipe);
            if (result.m_41619_()) continue;
            if (!inv.getStackInSlot(outputSlot.slotIndex).m_41619_()) {
                inv.getStackInSlot(outputSlot.slotIndex).m_41769_(result.m_41613_());
                continue;
            }
            inv.setStackInSlot(outputSlot.slotIndex, result.m_41777_());
        }
    }

    private int getProcessTime(R recipe) {
        return this.getProcessingTime.applyAsInt(recipe);
    }

    public class StateView
    implements ContainerData {
        public static final int LAST_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int PROCESS_MAX = 2;
        public static final int CURRENT_PROCESS = 3;
        public static final int NUM_SLOTS = 4;

        public static int getLastBurnTime(ContainerData data) {
            return data.m_6413_(0);
        }

        public static int getBurnTime(ContainerData data) {
            return data.m_6413_(1);
        }

        public static int getMaxProcess(ContainerData data) {
            return data.m_6413_(2);
        }

        public static int getProcess(ContainerData data) {
            return data.m_6413_(3);
        }

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FurnaceHandler.this.lastBurnTime;
                }
                case 1: {
                    return FurnaceHandler.this.burnTime;
                }
                case 2: {
                    return FurnaceHandler.this.processMax;
                }
                case 3: {
                    return FurnaceHandler.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceHandler.this.lastBurnTime = value;
                    break;
                }
                case 1: {
                    FurnaceHandler.this.burnTime = value;
                    break;
                }
                case 2: {
                    FurnaceHandler.this.processMax = value;
                    break;
                }
                case 3: {
                    FurnaceHandler.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }

    public static interface IFurnaceEnvironment<R extends IESerializableRecipe> {
        public IItemHandlerModifiable getInventory();

        @Nullable
        public R getRecipeForInput();

        public int getBurnTimeOf(Level var1, ItemStack var2);

        default public int getProcessSpeed(IMultiblockLevel level) {
            return 1;
        }

        default public void turnOff(IMultiblockLevel level) {
        }
    }

    protected static class InputSlot<R> {
        private final Function<R, IngredientWithSize> getFromRecipe;
        private final int slotIndex;

        public InputSlot(Function<R, IngredientWithSize> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public IngredientWithSize get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }

    protected static class OutputSlot<R> {
        private final Function<R, Lazy<ItemStack>> getFromRecipe;
        private final int slotIndex;

        public OutputSlot(Function<R, Lazy<ItemStack>> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public ItemStack get(R recipe) {
            return (ItemStack)this.getFromRecipe.apply(recipe).get();
        }
    }
}

