/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class GeneratorFuel
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<GeneratorFuel>> SERIALIZER;
    public static final CachedRecipeList<GeneratorFuel> RECIPES;
    private final FastEither<TagKey<Fluid>, List<Fluid>> fluids;
    private final int burnTime;

    public GeneratorFuel(ResourceLocation id, TagKey<Fluid> fluids, int burnTime) {
        super((Lazy<ItemStack>)LAZY_EMPTY, IERecipeTypes.GENERATOR_FUEL, id);
        this.fluids = FastEither.left(fluids);
        this.burnTime = burnTime;
    }

    public GeneratorFuel(ResourceLocation id, List<Fluid> fluids, int burnTime) {
        super((Lazy<ItemStack>)LAZY_EMPTY, IERecipeTypes.GENERATOR_FUEL, id);
        this.fluids = FastEither.right(fluids);
        this.burnTime = burnTime;
    }

    public List<Fluid> getFluids() {
        return this.fluids.map(t -> TagUtils.elementStream(BuiltInRegistries.f_257020_, t).toList(), Function.identity());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean matches(Fluid in) {
        if (this.fluids.isLeft()) {
            return in.m_205067_(this.fluids.leftNonnull());
        }
        return this.fluids.rightNonnull().contains(in);
    }

    public static GeneratorFuel getRecipeFor(Level level, Fluid in, @Nullable GeneratorFuel hint) {
        if (hint != null && hint.matches(in)) {
            return hint;
        }
        for (GeneratorFuel fuel : RECIPES.getRecipes(level)) {
            if (!fuel.matches(in)) continue;
            return fuel;
        }
        return null;
    }

    public static SortedMap<Component, Integer> getManualFuelList(Level level) {
        TreeMap<Component, Integer> map = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, Comparator.naturalOrder()));
        for (GeneratorFuel recipe : RECIPES.getRecipes(level)) {
            for (Fluid f : recipe.getFluids()) {
                map.put(f.getFluidType().getDescription(), recipe.getBurnTime());
            }
        }
        return map;
    }

    static {
        RECIPES = new CachedRecipeList<GeneratorFuel>(IERecipeTypes.GENERATOR_FUEL);
    }
}

