/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import guideme.color.ColorValue;
import guideme.scene.annotation.InWorldAnnotation;
import java.util.OptionalDouble;
import net.minecraft.core.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Intersectionf;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class InWorldBoxAnnotation
extends InWorldAnnotation {
    public static final float DEFAULT_THICKNESS = 0.03125f;
    private final Vector3f minCorner;
    private final Vector3f maxCorner;
    private final ColorValue color;
    private final float thickness;

    public InWorldBoxAnnotation(Vector3f minCorner, Vector3f maxCorner, ColorValue color, float thickness) {
        this.minCorner = minCorner;
        this.maxCorner = maxCorner;
        this.color = color;
        this.thickness = thickness;
    }

    public InWorldBoxAnnotation(Vector3f minCorner, Vector3f maxCorner, ColorValue color) {
        this(minCorner, maxCorner, color, 0.03125f);
    }

    public static InWorldBoxAnnotation forBlock(BlockPos pos, ColorValue color) {
        return new InWorldBoxAnnotation(new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()), new Vector3f((float)(pos.m_123341_() + 1), (float)(pos.m_123342_() + 1), (float)(pos.m_123343_() + 1)), color);
    }

    @Override
    public OptionalDouble intersect(Vector3f rayOrigin, Vector3f rayDir) {
        Vector2f intersection;
        Vector3f maxExtruded;
        Vector3f minExtruded = new Vector3f((Vector3fc)this.minCorner).sub(this.thickness, this.thickness, this.thickness);
        if (Intersectionf.intersectRayAab((Vector3fc)rayOrigin, (Vector3fc)rayDir, (Vector3fc)minExtruded, (Vector3fc)(maxExtruded = new Vector3f((Vector3fc)this.maxCorner).add(this.thickness, this.thickness, this.thickness)), (Vector2f)(intersection = new Vector2f()))) {
            return OptionalDouble.of(intersection.x);
        }
        return OptionalDouble.empty();
    }

    @Override
    public Pair<Vector2f, Vector2f> getScreenBounds(Matrix4f viewMatrix) {
        Vector3f minScreen = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f maxScreen = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f tmpPos = new Vector3f();
        for (int xCorner = 0; xCorner <= 1; ++xCorner) {
            for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                    float x = xCorner == 0 ? this.minCorner.x - this.thickness : this.maxCorner.x + this.thickness;
                    float y = yCorner == 0 ? this.minCorner.y - this.thickness : this.maxCorner.y + this.thickness;
                    float z = zCorner == 0 ? this.minCorner.z - this.thickness : this.maxCorner.z + this.thickness;
                    viewMatrix.transformPosition(x, y, z, tmpPos);
                    minScreen.min((Vector3fc)tmpPos);
                    maxScreen.max((Vector3fc)tmpPos);
                }
            }
        }
        return Pair.of((Object)new Vector2f(minScreen.x, minScreen.y), (Object)new Vector2f(maxScreen.x, maxScreen.y));
    }

    public Vector3f min() {
        return this.minCorner;
    }

    public Vector3f max() {
        return this.maxCorner;
    }

    public ColorValue color() {
        return this.color;
    }

    public float thickness() {
        return this.thickness;
    }
}

