/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BaseCompositeReader;
import guideme.internal.shaded.lucene.index.IndexCommit;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.SegmentInfos;
import guideme.internal.shaded.lucene.index.StandardDirectoryReader;
import guideme.internal.shaded.lucene.store.Directory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class DirectoryReader
extends BaseCompositeReader<LeafReader> {
    protected final Directory directory;

    public static DirectoryReader open(Directory directory) throws IOException {
        return StandardDirectoryReader.open(directory, null, null);
    }

    public static DirectoryReader open(Directory directory, Comparator<LeafReader> leafSorter) throws IOException {
        return StandardDirectoryReader.open(directory, null, leafSorter);
    }

    public static DirectoryReader open(IndexWriter writer) throws IOException {
        return DirectoryReader.open(writer, true, false);
    }

    public static DirectoryReader open(IndexWriter writer, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        return writer.getReader(applyAllDeletes, writeAllDeletes);
    }

    public static DirectoryReader open(IndexCommit commit) throws IOException {
        return StandardDirectoryReader.open(commit.getDirectory(), commit, null);
    }

    public static DirectoryReader open(IndexCommit commit, int minSupportedMajorVersion, Comparator<LeafReader> leafSorter) throws IOException {
        return StandardDirectoryReader.open(commit.getDirectory(), minSupportedMajorVersion, commit, leafSorter);
    }

    public static DirectoryReader openIfChanged(DirectoryReader oldReader) throws IOException {
        DirectoryReader newReader = oldReader.doOpenIfChanged();
        assert (newReader != oldReader);
        return newReader;
    }

    public static DirectoryReader openIfChanged(DirectoryReader oldReader, IndexCommit commit) throws IOException {
        DirectoryReader newReader = oldReader.doOpenIfChanged(commit);
        assert (newReader != oldReader);
        return newReader;
    }

    public static DirectoryReader openIfChanged(DirectoryReader oldReader, IndexWriter writer) throws IOException {
        return DirectoryReader.openIfChanged(oldReader, writer, true);
    }

    public static DirectoryReader openIfChanged(DirectoryReader oldReader, IndexWriter writer, boolean applyAllDeletes) throws IOException {
        DirectoryReader newReader = oldReader.doOpenIfChanged(writer, applyAllDeletes);
        assert (newReader != oldReader);
        return newReader;
    }

    public static List<IndexCommit> listCommits(Directory dir) throws IOException {
        String[] files = dir.listAll();
        ArrayList<IndexCommit> commits = new ArrayList<IndexCommit>();
        SegmentInfos latest = SegmentInfos.readLatestCommit(dir, 0);
        long currentGen = latest.getGeneration();
        commits.add(new StandardDirectoryReader.ReaderCommit(null, latest, dir));
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!fileName.startsWith("segments") || SegmentInfos.generationFromSegmentsFileName(fileName) >= currentGen) continue;
            SegmentInfos sis = null;
            try {
                sis = SegmentInfos.readCommit(dir, fileName, 0);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                // empty catch block
            }
            if (sis == null) continue;
            commits.add(new StandardDirectoryReader.ReaderCommit(null, sis, dir));
        }
        Collections.sort(commits);
        return commits;
    }

    public static boolean indexExists(Directory directory) throws IOException {
        String[] files = directory.listAll();
        String prefix = "segments_";
        for (String file : files) {
            if (!file.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected DirectoryReader(Directory directory, LeafReader[] segmentReaders, Comparator<LeafReader> leafSorter) throws IOException {
        super((IndexReader[])segmentReaders, leafSorter);
        this.directory = directory;
    }

    public final Directory directory() {
        return this.directory;
    }

    protected abstract DirectoryReader doOpenIfChanged() throws IOException;

    protected abstract DirectoryReader doOpenIfChanged(IndexCommit var1) throws IOException;

    protected abstract DirectoryReader doOpenIfChanged(IndexWriter var1, boolean var2) throws IOException;

    public abstract long getVersion();

    public abstract boolean isCurrent() throws IOException;

    public abstract IndexCommit getIndexCommit() throws IOException;
}

