/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.range;

import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.LongValues;
import guideme.internal.shaded.lucene.search.LongValuesSource;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.InPlaceMergeSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class DynamicRangeUtil {
    private DynamicRangeUtil() {
    }

    public static List<DynamicRangeInfo> computeDynamicRanges(String weightFieldName, LongValuesSource weightValueSource, LongValuesSource fieldValueSource, FacetsCollector facetsCollector, int topN, ExecutorService exec) throws IOException {
        List<FacetsCollector.MatchingDocs> matchingDocsList = facetsCollector.getMatchingDocs();
        int totalDoc = matchingDocsList.stream().mapToInt(matchingDoc -> matchingDoc.totalHits).sum();
        long[] values = new long[totalDoc];
        long[] weights = new long[totalDoc];
        long totalWeight = 0L;
        int overallLength = 0;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ArrayList<SegmentTask> tasks = new ArrayList<SegmentTask>();
        for (FacetsCollector.MatchingDocs matchingDocs : matchingDocsList) {
            if (matchingDocs.totalHits <= 0) continue;
            SegmentOutput segmentOutput = new SegmentOutput(matchingDocs.totalHits);
            SegmentTask task = new SegmentTask(matchingDocs, fieldValueSource, weightValueSource, segmentOutput);
            tasks.add(task);
            futures.add(exec.submit(task));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                IOUtils.rethrowAlways(ee.getCause());
            }
        }
        for (SegmentTask segmentTask : tasks) {
            SegmentOutput curSegmentOutput = segmentTask.segmentOutput;
            if (curSegmentOutput == null) {
                return null;
            }
            assert (curSegmentOutput.values.length == curSegmentOutput.weights.length);
            try {
                totalWeight = Math.addExact(curSegmentOutput.segmentTotalWeight, totalWeight);
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("weight field \"" + weightFieldName + "\": long totalWeight value out of bounds", ae);
            }
            int currSegmentLen = curSegmentOutput.segmentIdx;
            System.arraycopy(curSegmentOutput.values, 0, values, overallLength, currSegmentLen);
            System.arraycopy(curSegmentOutput.weights, 0, weights, overallLength, currSegmentLen);
            overallLength += currSegmentLen;
        }
        return DynamicRangeUtil.computeDynamicNumericRanges(values, weights, overallLength, totalWeight, topN);
    }

    public static List<DynamicRangeInfo> computeDynamicNumericRanges(final long[] values, final long[] weights, int len, long totalWeight, int topN) {
        assert (values.length == weights.length && len <= values.length && len >= 0);
        assert (topN >= 0);
        ArrayList<DynamicRangeInfo> dynamicRangeResult = new ArrayList<DynamicRangeInfo>();
        if (len == 0 || topN == 0) {
            return dynamicRangeResult;
        }
        new InPlaceMergeSorter(){

            @Override
            protected int compare(int index1, int index2) {
                int cmp = Long.compare(values[index1], values[index2]);
                if (cmp == 0) {
                    return Long.compare(weights[index1], weights[index2]);
                }
                return cmp;
            }

            @Override
            protected void swap(int index1, int index2) {
                long tmp = values[index1];
                values[index1] = values[index2];
                values[index2] = tmp;
                tmp = weights[index1];
                weights[index1] = weights[index2];
                weights[index2] = tmp;
            }
        }.sort(0, len);
        long accuWeight = 0L;
        long valueSum = 0L;
        int count = 0;
        int minIdx = 0;
        double rangeWeightTarget = (double)totalWeight / (double)Math.min(topN, len);
        for (int i = 0; i < len; ++i) {
            accuWeight += weights[i];
            valueSum += values[i];
            ++count;
            if (!((double)accuWeight >= rangeWeightTarget)) continue;
            dynamicRangeResult.add(new DynamicRangeInfo(count, accuWeight, values[minIdx], values[i], (double)valueSum / (double)count));
            count = 0;
            accuWeight = 0L;
            valueSum = 0L;
            minIdx = i + 1;
        }
        if (minIdx < len) {
            dynamicRangeResult.add(new DynamicRangeInfo(count, accuWeight, values[minIdx], values[len - 1], (double)valueSum / (double)count));
        }
        return dynamicRangeResult;
    }

    public static class DynamicRangeInfo {
        public int count;
        public long weight;
        public long min;
        public long max;
        public double centroid;

        public DynamicRangeInfo(int count, long weight, long min, long max, double centroid) {
            this.count = count;
            this.weight = weight;
            this.min = min;
            this.max = max;
            this.centroid = centroid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicRangeInfo that = (DynamicRangeInfo)o;
            return this.count == that.count && this.weight == that.weight && this.min == that.min && this.max == that.max && this.centroid == that.centroid;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.weight, this.min, this.max, this.centroid);
        }
    }

    private static final class SegmentOutput {
        private final long[] values;
        private final long[] weights;
        private long segmentTotalWeight;
        private int segmentIdx;

        public SegmentOutput(int hitsLength) {
            this.values = new long[hitsLength];
            this.weights = new long[hitsLength];
        }
    }

    private static class SegmentTask
    implements Callable<Void> {
        private final FacetsCollector.MatchingDocs matchingDocs;
        private final DocIdSetIterator matchingParentDocsItr;
        private final LongValuesSource fieldValueSource;
        private final LongValuesSource weightValueSource;
        private SegmentOutput segmentOutput;

        SegmentTask(FacetsCollector.MatchingDocs matchingDocs, LongValuesSource fieldValueSource, LongValuesSource weightValueSource, SegmentOutput segmentOutput) throws IOException {
            this.matchingDocs = matchingDocs;
            this.matchingParentDocsItr = matchingDocs.bits.iterator();
            this.fieldValueSource = fieldValueSource;
            this.weightValueSource = weightValueSource;
            this.segmentOutput = segmentOutput;
        }

        @Override
        public Void call() throws Exception {
            LongValues fieldValue = this.fieldValueSource.getValues(this.matchingDocs.context, null);
            LongValues weightValue = this.weightValueSource.getValues(this.matchingDocs.context, null);
            int doc = this.matchingParentDocsItr.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fieldValue.advanceExact(doc) && weightValue.advanceExact(doc)) {
                    long curValue = fieldValue.longValue();
                    long curWeight = weightValue.longValue();
                    if (curWeight != 0L) {
                        this.segmentOutput.values[this.segmentOutput.segmentIdx] = curValue;
                        this.segmentOutput.weights[this.segmentOutput.segmentIdx] = curWeight;
                        try {
                            this.segmentOutput.segmentTotalWeight = Math.addExact(this.segmentOutput.segmentTotalWeight, curWeight);
                        }
                        catch (ArithmeticException ae) {
                            throw new IllegalArgumentException("segment long totalWeight value out of bounds", ae);
                        }
                        ++this.segmentOutput.segmentIdx;
                    }
                }
                doc = this.matchingParentDocsItr.nextDoc();
            }
            return null;
        }
    }
}

