/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.IndexFormatTooNewException;
import guideme.internal.shaded.lucene.index.IndexFormatTooOldException;
import guideme.internal.shaded.lucene.store.BufferedChecksumIndexInput;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.StringHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class CodecUtil {
    public static final int CODEC_MAGIC = 1071082519;
    public static final int FOOTER_MAGIC = -1071082520;

    private CodecUtil() {
    }

    public static void writeHeader(DataOutput out, String codec, int version) throws IOException {
        BytesRef bytes = new BytesRef(codec);
        if (bytes.length != codec.length() || bytes.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + codec + "]");
        }
        CodecUtil.writeBEInt(out, 1071082519);
        out.writeString(codec);
        CodecUtil.writeBEInt(out, version);
    }

    public static void writeIndexHeader(DataOutput out, String codec, int version, byte[] id, String suffix) throws IOException {
        if (id.length != 16) {
            throw new IllegalArgumentException("Invalid id: " + StringHelper.idToString(id));
        }
        CodecUtil.writeHeader(out, codec, version);
        out.writeBytes(id, 0, id.length);
        BytesRef suffixBytes = new BytesRef(suffix);
        if (suffixBytes.length != suffix.length() || suffixBytes.length >= 256) {
            throw new IllegalArgumentException("suffix must be simple ASCII, less than 256 characters in length [got " + suffix + "]");
        }
        out.writeByte((byte)suffixBytes.length);
        out.writeBytes(suffixBytes.bytes, suffixBytes.offset, suffixBytes.length);
    }

    public static int headerLength(String codec) {
        return 9 + codec.length();
    }

    public static int indexHeaderLength(String codec, String suffix) {
        return CodecUtil.headerLength(codec) + 16 + 1 + suffix.length();
    }

    public static int checkHeader(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        int actualHeader = CodecUtil.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        return CodecUtil.checkHeaderNoMagic(in, codec, minVersion, maxVersion);
    }

    public static int checkHeaderNoMagic(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        String actualCodec = in.readString();
        if (!actualCodec.equals(codec)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + actualCodec + " vs expected codec=" + codec, in);
        }
        int actualVersion = CodecUtil.readBEInt(in);
        if (actualVersion < minVersion) {
            throw new IndexFormatTooOldException(in, actualVersion, minVersion, maxVersion);
        }
        if (actualVersion > maxVersion) {
            throw new IndexFormatTooNewException(in, actualVersion, minVersion, maxVersion);
        }
        return actualVersion;
    }

    public static int checkIndexHeader(DataInput in, String codec, int minVersion, int maxVersion, byte[] expectedID, String expectedSuffix) throws IOException {
        int version = CodecUtil.checkHeader(in, codec, minVersion, maxVersion);
        CodecUtil.checkIndexHeaderID(in, expectedID);
        CodecUtil.checkIndexHeaderSuffix(in, expectedSuffix);
        return version;
    }

    public static void verifyAndCopyIndexHeader(IndexInput in, DataOutput out, byte[] expectedID) throws IOException {
        if (in.length() < (long)(CodecUtil.footerLength() + CodecUtil.headerLength(""))) {
            throw new CorruptIndexException("compound sub-files must have a valid codec header and footer: file is too small (" + in.length() + " bytes)", in);
        }
        int actualHeader = CodecUtil.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("compound sub-files must have a valid codec header and footer: codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        String codec = in.readString();
        int version = CodecUtil.readBEInt(in);
        CodecUtil.checkIndexHeaderID(in, expectedID);
        int suffixLength = in.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in.readBytes(suffixBytes, 0, suffixLength);
        CodecUtil.writeBEInt(out, 1071082519);
        out.writeString(codec);
        CodecUtil.writeBEInt(out, version);
        out.writeBytes(expectedID, 0, expectedID.length);
        out.writeByte((byte)suffixLength);
        out.writeBytes(suffixBytes, 0, suffixLength);
    }

    public static byte[] readIndexHeader(IndexInput in) throws IOException {
        in.seek(0L);
        int actualHeader = CodecUtil.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        String codec = in.readString();
        CodecUtil.readBEInt(in);
        in.seek(in.getFilePointer() + 16L);
        int suffixLength = in.readByte() & 0xFF;
        byte[] bytes = new byte[CodecUtil.headerLength(codec) + 16 + 1 + suffixLength];
        in.seek(0L);
        in.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] readFooter(IndexInput in) throws IOException {
        if (in.length() < (long)CodecUtil.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + CodecUtil.footerLength(), in);
        }
        in.seek(in.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(in);
        in.seek(in.length() - (long)CodecUtil.footerLength());
        byte[] bytes = new byte[CodecUtil.footerLength()];
        in.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] checkIndexHeaderID(DataInput in, byte[] expectedID) throws IOException {
        byte[] id = new byte[16];
        in.readBytes(id, 0, id.length);
        if (!Arrays.equals(id, expectedID)) {
            throw new CorruptIndexException("file mismatch, expected id=" + StringHelper.idToString(expectedID) + ", got=" + StringHelper.idToString(id), in);
        }
        return id;
    }

    public static String checkIndexHeaderSuffix(DataInput in, String expectedSuffix) throws IOException {
        int suffixLength = in.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in.readBytes(suffixBytes, 0, suffixBytes.length);
        String suffix = new String(suffixBytes, StandardCharsets.UTF_8);
        if (!suffix.equals(expectedSuffix)) {
            throw new CorruptIndexException("file mismatch, expected suffix=" + expectedSuffix + ", got=" + suffix, in);
        }
        return suffix;
    }

    public static void writeFooter(IndexOutput out) throws IOException {
        CodecUtil.writeBEInt(out, -1071082520);
        CodecUtil.writeBEInt(out, 0);
        CodecUtil.writeCRC(out);
    }

    public static int footerLength() {
        return 16;
    }

    public static long checkFooter(ChecksumIndexInput in) throws IOException {
        CodecUtil.validateFooter(in);
        long actualChecksum = in.getChecksum();
        long expectedChecksum = CodecUtil.readCRC(in);
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(expectedChecksum) + " actual=" + Long.toHexString(actualChecksum), in);
        }
        return actualChecksum;
    }

    public static void checkFooter(ChecksumIndexInput in, Throwable priorException) throws IOException {
        if (priorException != null) {
            try {
                long remaining = in.length() - in.getFilePointer();
                if (remaining < (long)CodecUtil.footerLength()) {
                    throw new CorruptIndexException("checksum status indeterminate: remaining=" + remaining + "; please run checkindex for more details", in);
                }
                in.skipBytes(remaining - (long)CodecUtil.footerLength());
                long checksum = CodecUtil.checkFooter(in);
                if (!(priorException instanceof IndexFormatTooOldException)) {
                    priorException.addSuppressed(new CorruptIndexException("checksum passed (" + Long.toHexString(checksum) + "). possibly transient resource issue, or a Lucene or JVM bug", in));
                }
            }
            catch (CorruptIndexException corruptException) {
                corruptException.addSuppressed(priorException);
                throw corruptException;
            }
            catch (Throwable t) {
                priorException.addSuppressed(new CorruptIndexException("checksum status indeterminate: unexpected exception", in, t));
            }
            throw IOUtils.rethrowAlways(priorException);
        }
        CodecUtil.checkFooter(in);
    }

    public static long retrieveChecksum(IndexInput in) throws IOException {
        if (in.length() < (long)CodecUtil.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + CodecUtil.footerLength(), in);
        }
        in.seek(in.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(in);
        return CodecUtil.readCRC(in);
    }

    public static long retrieveChecksum(IndexInput in, long expectedLength) throws IOException {
        if (expectedLength < (long)CodecUtil.footerLength()) {
            throw new IllegalArgumentException("expectedLength cannot be less than the footer length");
        }
        if (in.length() < expectedLength) {
            throw new CorruptIndexException("truncated file: length=" + in.length() + " but expectedLength==" + expectedLength, in);
        }
        if (in.length() > expectedLength) {
            throw new CorruptIndexException("file too long: length=" + in.length() + " but expectedLength==" + expectedLength, in);
        }
        return CodecUtil.retrieveChecksum(in);
    }

    private static void validateFooter(IndexInput in) throws IOException {
        long expected;
        long remaining = in.length() - in.getFilePointer();
        if (remaining < (expected = (long)CodecUtil.footerLength())) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
        }
        if (remaining > expected) {
            throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
        }
        int magic = CodecUtil.readBEInt(in);
        if (magic != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + magic + " vs expected footer=-1071082520", in);
        }
        int algorithmID = CodecUtil.readBEInt(in);
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID, in);
        }
    }

    public static long checksumEntireFile(IndexInput input) throws IOException {
        IndexInput clone = input.clone();
        clone.seek(0L);
        BufferedChecksumIndexInput in = new BufferedChecksumIndexInput(clone);
        assert (((IndexInput)in).getFilePointer() == 0L);
        if (((IndexInput)in).length() < (long)CodecUtil.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + ((IndexInput)in).length() + " but footerLength==" + CodecUtil.footerLength(), input);
        }
        in.seek(((IndexInput)in).length() - (long)CodecUtil.footerLength());
        return CodecUtil.checkFooter(in);
    }

    static long readCRC(IndexInput input) throws IOException {
        long value = CodecUtil.readBELong(input);
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new CorruptIndexException("Illegal CRC-32 checksum: " + value, input);
        }
        return value;
    }

    static void writeCRC(IndexOutput output) throws IOException {
        long value = output.getChecksum();
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("Illegal CRC-32 checksum: " + value + " (resource=" + output + ")");
        }
        CodecUtil.writeBELong(output, value);
    }

    public static void writeBEInt(DataOutput out, int i) throws IOException {
        out.writeByte((byte)(i >> 24));
        out.writeByte((byte)(i >> 16));
        out.writeByte((byte)(i >> 8));
        out.writeByte((byte)i);
    }

    public static void writeBELong(DataOutput out, long l) throws IOException {
        CodecUtil.writeBEInt(out, (int)(l >> 32));
        CodecUtil.writeBEInt(out, (int)l);
    }

    public static int readBEInt(DataInput in) throws IOException {
        return (in.readByte() & 0xFF) << 24 | (in.readByte() & 0xFF) << 16 | (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF;
    }

    public static long readBELong(DataInput in) throws IOException {
        return (long)CodecUtil.readBEInt(in) << 32 | (long)CodecUtil.readBEInt(in) & 0xFFFFFFFFL;
    }
}

