/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipeBuilder;
import com.oierbravo.createmechanicalextruder.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirementType;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.BiomeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.MaxHeightRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.MinHeightRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.SpeedRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ExtrudingRecipe
implements Recipe<SimpleContainer>,
IRecipeTypeInfo,
IRecipeWithRequirements {
    public static Comparator<? super ExtrudingRecipe> hasCatalyst;
    private ResourceLocation id;
    private NonNullList<Ingredient> itemIngredients;
    private NonNullList<FluidIngredient> fluidIngredients;
    private ItemStack catalyst;
    private ProcessingOutput result;
    private int requiredBonks;
    private final Map<RecipeRequirementType<?>, RecipeRequirement> recipeRequirements = new HashMap();
    private static final List<RecipeRequirementType<?>> enabledRecipeRequirements;

    public ExtrudingRecipe(ExtrudingRecipeBuilder.ExtrudingRecipeParams params) {
        this.id = params.id;
        this.result = params.result;
        this.itemIngredients = params.itemIngredients;
        this.fluidIngredients = params.fluidIngredients;
        this.catalyst = params.catalyst;
        this.requiredBonks = params.requiredBonks;
        params.recipeRequirements.forEach(recipeRequirement -> this.recipeRequirements.put(recipeRequirement.getType(), (RecipeRequirement)recipeRequirement));
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.result.rollOutput();
    }

    public static boolean match(ExtruderBlockEntity extruderBlockEntity, ExtrudingRecipe recipe) {
        FilteringBehaviour filter = extruderBlockEntity.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(extruderBlockEntity.m_58904_().m_9598_()));
        if (!ExtrudingRecipe.getAllIngredientsStringList(recipe).equals(extruderBlockEntity.getAllIngredientsStringList())) {
            return false;
        }
        if (!recipe.catalyst.m_41619_() && !recipe.catalyst.m_150930_(extruderBlockEntity.getCatalystItem())) {
            return false;
        }
        return filterTest;
    }

    public boolean hasCatalyst() {
        return !this.getCatalyst().m_41619_();
    }

    public List<Ingredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public static List<String> getAllIngredientsStringList(ExtrudingRecipe recipe) {
        ArrayList<String> list = new ArrayList<String>();
        recipe.getItemIngredients().forEach(ingredient -> list.add(ingredient.m_43908_()[0].m_41720_().toString()));
        recipe.getFluidIngredients().forEach(ingredient -> list.add(((FluidStack)ingredient.getMatchingFluidStacks().get(0)).getFluid().getFluidType().getDescriptionId()));
        Collections.sort(list);
        return list;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.rollOutput();
    }

    public ItemStack getResultItem() {
        return this.result.rollOutput();
    }

    public ProcessingOutput getResult() {
        return this.result;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public int getRequiredBonks() {
        return this.requiredBonks;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public List<RecipeRequirementType<?>> getEnabledRequirements() {
        return enabledRecipeRequirements;
    }

    @Override
    public Map<RecipeRequirementType<?>, RecipeRequirement> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public <T extends RecipeRequirement> T getRequirement(RecipeRequirementType<T> type) {
        return (T)this.recipeRequirements.get(type);
    }

    static {
        enabledRecipeRequirements = List.of(BiomeRequirement.TYPE, MinHeightRequirement.TYPE, MaxHeightRequirement.TYPE, SpeedRequirement.TYPE);
    }

    public static class Serializer
    implements RecipeSerializer<ExtrudingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("create_mechanical_extruder", "extruding");

        public ExtrudingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ExtrudingRecipeBuilder builder = new ExtrudingRecipeBuilder(id);
            NonNullList itemIngredients = NonNullList.m_122779_();
            NonNullList fluidIngredients = NonNullList.m_122779_();
            ProcessingOutput result = ProcessingOutput.EMPTY;
            ItemStack catalyst = ItemStack.f_41583_;
            int requiredBonks = 1;
            ArrayList<RecipeRequirement> recipeRequirements = new ArrayList<RecipeRequirement>();
            for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
                if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                    fluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)je));
                    continue;
                }
                itemIngredients.add((Object)Ingredient.m_43917_((JsonElement)je));
            }
            result = ProcessingOutput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            if (GsonHelper.m_13900_((JsonObject)json, (String)"catalyst")) {
                catalyst = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"requiredBonks")) {
                requiredBonks = GsonHelper.m_13927_((JsonObject)json, (String)"requiredBonks");
            }
            enabledRecipeRequirements.forEach(recipeRequirementType -> {
                if (GsonHelper.m_13900_((JsonObject)json, (String)recipeRequirementType.getId())) {
                    recipeRequirements.add((RecipeRequirement)recipeRequirementType.fromJson(json));
                }
            });
            return builder.withItemIngredients((NonNullList<Ingredient>)itemIngredients).withSingleItemOutput(result).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withCatalyst(catalyst).requiredBonks(requiredBonks).withRequirements(recipeRequirements).build();
        }

        public JsonObject toJson(JsonObject pJson, ExtrudingRecipe pRecipe) {
            JsonArray jsonIngredients = new JsonArray();
            pRecipe.itemIngredients.forEach(i -> jsonIngredients.add(i.m_43942_()));
            pRecipe.fluidIngredients.forEach(i -> jsonIngredients.add((JsonElement)i.serialize()));
            pJson.add("result", pRecipe.result.serialize());
            pJson.add("ingredients", (JsonElement)jsonIngredients);
            if (pRecipe.hasCatalyst()) {
                pJson.add("catalyst", new ProcessingOutput(pRecipe.getCatalyst(), 1.0f).serialize());
            }
            if (pRecipe.getRequiredBonks() > 1) {
                pJson.addProperty("requiredBonks", (Number)pRecipe.getRequiredBonks());
            }
            for (Map.Entry<RecipeRequirementType<?>, RecipeRequirement> entry : pRecipe.recipeRequirements.entrySet()) {
                pJson = entry.getKey().toJson(pJson, entry.getValue());
            }
            return pJson;
        }

        public ExtrudingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int i;
            ExtrudingRecipeBuilder builder = new ExtrudingRecipeBuilder(id);
            NonNullList itemIngredients = NonNullList.m_122779_();
            NonNullList fluidIngredients = NonNullList.m_122779_();
            ProcessingOutput result = ProcessingOutput.EMPTY;
            ItemStack catalyst = ItemStack.f_41583_;
            int requiredBonks = 1;
            ArrayList<RecipeRequirement> recipeRequirements = new ArrayList<RecipeRequirement>();
            int size = buffer.m_130242_();
            for (i = 0; i < size; ++i) {
                itemIngredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            size = buffer.m_130242_();
            for (i = 0; i < size; ++i) {
                fluidIngredients.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
            }
            result = ProcessingOutput.read((FriendlyByteBuf)buffer);
            catalyst = buffer.m_130267_();
            requiredBonks = buffer.readInt();
            enabledRecipeRequirements.forEach(recipeRequirementType -> recipeRequirements.add((RecipeRequirement)recipeRequirementType.fromNetwork(buffer)));
            return builder.withItemIngredients((NonNullList<Ingredient>)itemIngredients).withSingleItemOutput(result).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withCatalyst(catalyst).requiredBonks(requiredBonks).withRequirements(recipeRequirements).build();
        }

        public void toNetwork(FriendlyByteBuf buffer, ExtrudingRecipe pRecipe) {
            NonNullList<Ingredient> itemIngredients = pRecipe.itemIngredients;
            NonNullList<FluidIngredient> fluidIngredients = pRecipe.fluidIngredients;
            ProcessingOutput result = pRecipe.result;
            ItemStack catalyst = pRecipe.catalyst;
            int requiredBonks = pRecipe.requiredBonks;
            buffer.m_130130_(itemIngredients.size());
            itemIngredients.forEach(i -> i.m_43923_(buffer));
            buffer.m_130130_(fluidIngredients.size());
            fluidIngredients.forEach(i -> i.write(buffer));
            result.write(buffer);
            buffer.writeItemStack(catalyst, false);
            buffer.writeInt(requiredBonks);
            enabledRecipeRequirements.forEach(recipeRequirementType -> recipeRequirementType.toNetwork(buffer, (RecipeRequirement)pRecipe.getRequirement(recipeRequirementType)));
        }
    }

    public static class Type
    implements RecipeType<ExtrudingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "extruding";

        private Type() {
        }
    }
}

