/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.vanillabackport.common.api.leash.LeashState;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import com.blackgear.vanillabackport.core.mixin.access.EntityRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LeashRenderer<T extends Entity> {
    private final EntityRenderDispatcher dispatcher;
    @Nullable
    private List<LeashState> leashStates;

    public LeashRenderer(EntityRenderDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean shouldRender(T entity, Frustum camera, boolean isVisible, boolean fallback) {
        if (!isVisible) {
            Leashable leashable;
            Entity holder;
            AABB entityBox = entity.m_6921_().m_82400_(0.5);
            if (entityBox.m_82392_() || entityBox.m_82309_() == 0.0) {
                entityBox = new AABB(entity.m_20185_() - 2.0, entity.m_20186_() - 2.0, entity.m_20189_() - 2.0, entity.m_20185_() + 2.0, entity.m_20186_() + 2.0, entity.m_20189_() + 2.0);
            }
            if (camera.m_113029_(entityBox)) {
                return true;
            }
            if (entity instanceof Leashable && (holder = (leashable = (Leashable)entity).getLeashHolder()) != null) {
                AABB holderBox = holder.m_6921_();
                return camera.m_113029_(holderBox) || camera.m_113029_(entityBox.m_82367_(holderBox));
            }
        }
        return fallback;
    }

    public boolean shouldRender(T entity, Frustum camera, boolean isVisible) {
        return this.shouldRender(entity, camera, isVisible, isVisible);
    }

    public void render(T entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        this.setupLeashRendering(entity, partialTick);
        if (this.leashStates != null) {
            for (LeashState state : this.leashStates) {
                this.renderLeash(poseStack, buffer, state);
            }
        }
    }

    private void renderLeash(PoseStack stack, MultiBufferSource buffer, LeashState state) {
        int segment;
        float deltaX = (float)(state.end.f_82479_ - state.start.f_82479_);
        float deltaY = (float)(state.end.f_82480_ - state.start.f_82480_);
        float deltaZ = (float)(state.end.f_82481_ - state.start.f_82481_);
        float scaleFactor = Mth.m_264536_((float)(deltaX * deltaX + deltaZ * deltaZ)) * 0.05f / 2.0f;
        float offsetZ = deltaZ * scaleFactor;
        float offsetX = deltaX * scaleFactor;
        stack.m_85836_();
        stack.m_85837_(state.offset.f_82479_, state.offset.f_82480_, state.offset.f_82481_);
        VertexConsumer vertices = buffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrices = stack.m_85850_().m_252922_();
        for (segment = 0; segment <= 24; ++segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.05f, offsetZ, offsetX, segment, false, state);
        }
        for (segment = 24; segment >= 0; --segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.0f, offsetZ, offsetX, segment, true, state);
        }
        stack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertices, Matrix4f matrices, float deltaX, float deltaY, float deltaZ, float thickness1, float thickness2, float offsetZ, float offsetX, int segment, boolean isInnerFace, LeashState state) {
        float progress = (float)segment / 24.0f;
        int blockLight = (int)Mth.m_14179_((float)progress, (float)state.startBlockLight, (float)state.endBlockLight);
        int skyLight = (int)Mth.m_14179_((float)progress, (float)state.startSkyLight, (float)state.endSkyLight);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        float colorModifier = segment % 2 == (isInnerFace ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * colorModifier;
        float green = 0.4f * colorModifier;
        float blue = 0.3f * colorModifier;
        float posX = deltaX * progress;
        float posZ = deltaZ * progress;
        float posY = state.slack ? (deltaY > 0.0f ? deltaY * progress * progress : deltaY - deltaY * (1.0f - progress) * (1.0f - progress)) : deltaY * progress;
        vertices.m_252986_(matrices, posX - offsetZ, posY + thickness2, posZ + offsetX).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        vertices.m_252986_(matrices, posX + offsetZ, posY + thickness1 - thickness2, posZ - offsetX).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    private void setupLeashRendering(T entity, float partialTicks) {
        if (!(entity instanceof Leashable)) {
            this.leashStates = null;
            return;
        }
        Leashable leashable = (Leashable)entity;
        Entity leashHolder = leashable.getLeashHolder();
        if (leashHolder != null) {
            int leashCount;
            Leashable ext;
            float entityRotation = Leashable.getPreciseBodyRotation(entity, partialTicks) * ((float)Math.PI / 180);
            Vec3 leashOffset = entity.m_245894_(partialTicks);
            BlockPos entityPos = BlockPos.m_274446_((Position)entity.m_20299_(partialTicks));
            BlockPos holderPos = BlockPos.m_274446_((Position)leashHolder.m_20299_(partialTicks));
            int entityBlockLight = this.getBlockLightLevel((Entity)entity, entityPos);
            int holderBlockLight = this.getBlockLightLevel(leashHolder, holderPos);
            int entitySkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, entityPos);
            int holderSkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, holderPos);
            boolean handleHolderQuadLeash = leashHolder instanceof Leashable && (ext = (Leashable)leashHolder).supportQuadLeashAsHolder();
            boolean handleQuadLeash = leashable.supportQuadLeash();
            boolean useQuadLeash = handleHolderQuadLeash && handleQuadLeash;
            int n = leashCount = useQuadLeash ? 4 : 1;
            if (this.leashStates == null || this.leashStates.size() != leashCount) {
                this.leashStates = new ArrayList<LeashState>(leashCount);
                for (int i = 0; i < leashCount; ++i) {
                    this.leashStates.add(new LeashState());
                }
            }
            if (useQuadLeash) {
                float holderRotation = Leashable.getPreciseBodyRotation(leashHolder, partialTicks) * ((float)Math.PI / 180);
                Vec3 holderPosition = leashHolder.m_20318_(partialTicks);
                Vec3[] entityOffsets = leashable.getQuadLeashOffsets();
                Vec3[] holderOffsets = ((Leashable)leashHolder).getQuadLeashHolderOffsets();
                for (int i = 0; i < leashCount; ++i) {
                    LeashState leashState = this.leashStates.get(i);
                    leashState.offset = entityOffsets[i].m_82524_(-entityRotation);
                    leashState.start = entity.m_20318_(partialTicks).m_82549_(leashState.offset);
                    leashState.end = holderPosition.m_82549_(holderOffsets[i].m_82524_(-holderRotation));
                    leashState.startBlockLight = entityBlockLight;
                    leashState.endBlockLight = holderBlockLight;
                    leashState.startSkyLight = entitySkyLight;
                    leashState.endSkyLight = holderSkyLight;
                    leashState.slack = false;
                }
            } else {
                Vec3 rotatedOffset = leashOffset.m_82524_(-entityRotation);
                LeashState leashState = this.leashStates.get(0);
                leashState.offset = rotatedOffset;
                leashState.start = entity.m_20318_(partialTicks).m_82549_(rotatedOffset);
                leashState.end = leashHolder.m_7398_(partialTicks);
                leashState.startBlockLight = entityBlockLight;
                leashState.endBlockLight = holderBlockLight;
                leashState.startSkyLight = entitySkyLight;
                leashState.endSkyLight = holderSkyLight;
            }
        } else {
            this.leashStates = null;
        }
    }

    private int getBlockLightLevel(Entity entity, BlockPos pos) {
        return ((EntityRendererAccessor)this.dispatcher.m_114382_(entity)).callGetBlockLightLevel(entity, pos);
    }
}

