/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.renderer;

import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.common.api.leash.LeashRenderer;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class PaleOakBoatRenderer
extends BoatRenderer {
    private static final ResourceLocation PALE_OAK_BOAT = VanillaBackport.resource("textures/entity/boat/pale_oak.png");
    private static final ResourceLocation PALE_OAK_CHEST_BOAT = VanillaBackport.resource("textures/entity/chest_boat/pale_oak.png");
    private final Pair<ResourceLocation, ListModel<Boat>> boatResource;
    private final LeashRenderer<Boat> leashRenderer;

    public PaleOakBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context, chestBoat);
        this.boatResource = Pair.of((Object)(chestBoat ? PALE_OAK_CHEST_BOAT : PALE_OAK_BOAT), (Object)(chestBoat ? new ChestBoatModel(context.m_174023_(ModModelLayers.PALE_OAK_CHEST_BOAT)) : new BoatModel(context.m_174023_(ModModelLayers.PALE_OAK_BOAT))));
        this.leashRenderer = new LeashRenderer(this.f_114476_);
    }

    public void m_7392_(Boat entity, float entityYaw, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int packedLight) {
        float bubbleAngle;
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.375f, 0.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float hurtTime = (float)entity.m_38385_() - partialTicks;
        float tilt = entity.m_38384_() - partialTicks;
        if (tilt < 0.0f) {
            tilt = 0.0f;
        }
        if (hurtTime > 0.0f) {
            matrices.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)hurtTime) * hurtTime * tilt / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = entity.m_38352_(partialTicks)), (float)0.0f)) {
            matrices.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(entity);
        ResourceLocation texture = (ResourceLocation)pair.getFirst();
        ListModel model = (ListModel)pair.getSecond();
        matrices.m_85841_(-1.0f, -1.0f, 1.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        model.m_6973_((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertices = buffer.m_6299_(model.m_103119_(texture));
        model.m_7695_(matrices, vertices, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer patch = buffer.m_6299_(RenderType.m_110478_());
            if (model instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)model;
                waterpatchmodel.m_102282_().m_104301_(matrices, patch, packedLight, OverlayTexture.f_118083_);
            }
        }
        matrices.m_85849_();
        if (this.m_6512_((Entity)entity)) {
            this.m_7649_((Entity)entity, entity.m_5446_(), matrices, buffer, packedLight);
        }
        this.leashRenderer.render(entity, partialTicks, matrices, buffer);
    }

    public boolean shouldRender(Boat entity, Frustum camera, double camX, double camY, double camZ) {
        return this.leashRenderer.shouldRender(entity, camera, super.m_5523_((Entity)entity, camera, camX, camY, camZ));
    }

    public ResourceLocation m_5478_(Boat entity) {
        return (ResourceLocation)this.getModelWithLocation(entity).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        return this.boatResource;
    }
}

