/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.snad.blocks;

import com.leclowndu93150.snad.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnadBlock
extends FallingBlock {
    public SnadBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, this.m_7198_());
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (SnadBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            level.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable.getPlantType(level, pos).equals(PlantType.DESERT)) {
            return true;
        }
        if (plantable.getPlantType(level, pos).equals(PlantType.BEACH)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean isWater = level.m_6425_(pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_);
                boolean isFrostedIce = level.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50449_);
                if (!isWater && !isFrostedIce) continue;
                return true;
            }
        }
        return super.canSustainPlant(state, level, pos, facing, plantable);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.m_213897_(pState, pLevel, pPos, pRandom);
    }

    public void m_213897_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (SnadBlock.m_53241_((BlockState)pLevel.m_8055_(pPos.m_7495_())) && pPos.m_123342_() >= pLevel.m_141937_()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            this.m_6788_(fallingBlockEntity);
        } else {
            this.grow(pState, pLevel, pPos, pRandom);
        }
    }

    public void grow(@NotNull BlockState pState, ServerLevel pLevel, BlockPos pPos, @NotNull RandomSource pRandom) {
        Block blockAbove = pLevel.m_8055_(pPos.m_7494_()).m_60734_();
        if (pLevel.m_276867_(pPos)) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                BlockPos currentPos = pPos.m_6630_(height);
                if (currentPos.m_123342_() < pLevel.m_151558_()) {
                    int growthAttemptsLimit;
                    Block nextBlock = pLevel.m_8055_(currentPos).m_60734_();
                    int n = growthAttemptsLimit = nextBlock instanceof BambooStalkBlock || nextBlock instanceof BambooSaplingBlock || nextBlock instanceof KelpPlantBlock ? Config.magicNumber2 : Config.magicNumber;
                    if (nextBlock.getClass() == blockAbove.getClass()) {
                        for (int growthAttempts = 0; growthAttempts < growthAttemptsLimit; ++growthAttempts) {
                            pLevel.m_8055_(currentPos).m_222972_(pLevel, currentPos, pRandom);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        }
    }
}

