/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidVesselRenderer
extends SafeBlockEntityRenderer<FluidVesselBlockEntity> {
    public FluidVesselRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(FluidVesselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.hasWindow()) {
            if (be.boiler.isActive()) {
                this.renderAsBoiler(be, partialTicks, ms, buffer, light, overlay);
            }
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capSize = 0.25f;
        float tankHullSize = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getWidth() - 2.0f * tankHullSize - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = be.getTankInventory();
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        Direction.Axis axis = be.getAxis();
        float xMin = axis == Direction.Axis.X ? capSize : tankHullSize;
        float xMax = axis == Direction.Axis.X ? xMin + (float)be.getHeight() - 2.0f * capSize : xMin + (float)be.getWidth() - 2.0f * tankHullSize;
        float yMin = totalHeight + tankHullSize + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = axis == Direction.Axis.Z ? capSize : tankHullSize;
        float zMax = axis == Direction.Axis.Z ? zMin + (float)be.getHeight() - 2.0f * capSize : zMin + (float)be.getWidth() - 2.0f * tankHullSize;
        ms.m_85836_();
        ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.m_85849_();
    }

    protected void renderAsBoiler(FluidVesselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110463_());
        ms.m_85836_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        Direction.Axis axis = be.getAxis();
        msr.translate(axis == Direction.Axis.X ? (double)((float)be.getHeight() / 2.0f) : (double)((float)be.getWidth() / 2.0f), 0.5, axis == Direction.Axis.Z ? (double)((float)be.getHeight() / 2.0f) : (double)((float)be.getWidth() / 2.0f));
        float dialPivotY = 0.375f;
        float dialPivotZ = 0.5f;
        float progress = be.boiler.gauge.getValue(partialTicks);
        for (Direction d : Iterate.horizontalDirections) {
            if (be.boiler.occludedDirections[d.m_122416_()] || d.m_122434_() != axis) continue;
            ms.m_85836_();
            float yRot = -d.m_122435_() - 90.0f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE, (BlockState)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.getWidth() / 2.0f - 0.375f, 0.0f, 0.0f)).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (BlockState)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.getWidth() / 2.0f - 0.375f, 0.0f, 0.0f)).translate(0.0f, dialPivotY, dialPivotZ)).rotateXDegrees(-145.0f * progress + 90.0f)).translate(0.0f, -dialPivotY, -dialPivotZ)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(FluidVesselBlockEntity be) {
        return be.isController();
    }
}

