/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.board;

import com.google.common.collect.ImmutableMap;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.copycat.MigratingWaterloggedCopycatBlock;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatBoardBlock
extends MigratingWaterloggedCopycatBlock
implements SpecialBlockItemRequirement {
    public static BooleanProperty UP = BlockStateProperties.f_61366_;
    public static BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.f_55154_;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public CopycatBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.m_152458_(CopycatBoardBlock::calculateMultifaceShape);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        return !reader.m_8055_(toPos).m_60713_((Block)this);
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return reader.m_8055_(toPos).m_60713_((Block)this);
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return (Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(face.m_122424_())) == false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    private static VoxelShape calculateMultifaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CCShapes.CASING_1PX.get(direction));
        }
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (this.isSelfState(state)) {
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)stateForPlacement.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(pUseContext.m_43719_().m_122424_()))).booleanValue()) {
            double loc;
            Direction direction = pUseContext.m_43719_().m_122424_();
            double pos = CopycatBoardBlock.getByAxis((Vec3i)pUseContext.m_8083_(), direction.m_122434_());
            if (CopycatBoardBlock.getByAxis(direction.m_122436_(), direction.m_122434_()) > 0) {
                pos += 1.0;
            }
            if (Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)pUseContext.m_43720_(), direction.m_122434_()))) < 0.125) {
                return true;
            }
        }
        if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(pUseContext.m_43719_()))).booleanValue()) {
            double hitLoc = CopycatBoardBlock.getByAxis((Position)pUseContext.m_43720_(), pUseContext.m_43719_().m_122434_());
            int direction = CopycatBoardBlock.getByAxis(pUseContext.m_43719_().m_122436_(), pUseContext.m_43719_().m_122434_());
            double offset = hitLoc - (double)Math.round(hitLoc);
            if (Mth.m_14205_((double)direction) == Mth.m_14205_((double)offset) && Math.abs(offset) < 0.125) {
                return true;
            }
        }
        return false;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        int faceCount = 0;
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            ++faceCount;
        }
        if (faceCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        ArrayList<Direction> options = new ArrayList<Direction>(6);
        for (Direction direction : Iterate.directions) {
            double loc;
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            double pos = CopycatBoardBlock.getByAxis((Vec3i)context.m_8083_(), direction.m_122434_());
            if (CopycatBoardBlock.getByAxis(direction.m_122436_(), direction.m_122434_()) > 0) {
                pos += 1.0;
            }
            if (!(Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)context.m_43720_(), direction.m_122434_()))) < 0.125)) continue;
            options.add(direction);
        }
        if (options.size() > 1) {
            Direction backup = (Direction)options.get(0);
            options.removeIf(d -> d.m_122434_() != context.m_43719_().m_122434_());
            if (options.size() == 0) {
                options.add(backup);
            }
        }
        if (options.size() == 0) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(true))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(false)));
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.m_5456_(), (int)Arrays.stream(Iterate.directions).filter(d -> (Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(d))).count()));
    }

    private static int getByAxis(Vec3i pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_123341_();
            case Direction.Axis.Y -> pos.m_123342_();
            case Direction.Axis.Z -> pos.m_123343_();
        };
    }

    private static double getByAxis(Position pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_7096_();
            case Direction.Axis.Y -> pos.m_7098_();
            case Direction.Axis.Z -> pos.m_7094_();
        };
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) && !((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(dir))).booleanValue()) {
            return false;
        }
        if (neighborState.m_60713_((Block)this) && !((Boolean)neighborState.m_61143_((Property)CopycatBoardBlock.byDirection(dir.m_122424_()))).booleanValue()) {
            return false;
        }
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this)) {
            return CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_());
        }
        return CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(neighborState, dir.m_122424_());
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRotation) {
        return this.mapDirections(pState, arg_0 -> ((Rotation)pRotation).m_55954_(arg_0));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, Mirror pMirror) {
        return this.mapDirections(pState, arg_0 -> ((Mirror)pMirror).m_54848_(arg_0));
    }

    private BlockState mapDirections(BlockState pState, Function<Direction, Direction> pDirectionalFunction) {
        BlockState blockstate = pState;
        for (Direction direction : Iterate.directions) {
            blockstate = (BlockState)blockstate.m_61124_((Property)CopycatBoardBlock.byDirection(pDirectionalFunction.apply(direction)), (Comparable)((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(direction))));
        }
        return blockstate;
    }

    public static BooleanProperty byDirection(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }
}

