/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.contraption.jukebox;

import com.hlysine.create_connected.content.contraption.jukebox.ContraptionMusicManager;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.network.NetworkEvent;

public class PlayContraptionJukeboxPacket
extends SimplePacketBase {
    protected ResourceLocation level;
    protected int contraptionId;
    protected BlockPos contraptionPos;
    protected BlockPos worldPos;
    protected int recordId;
    protected boolean play;
    protected boolean silent;

    public PlayContraptionJukeboxPacket(FriendlyByteBuf buffer) {
        this.level = buffer.m_130281_();
        this.contraptionId = buffer.readInt();
        this.contraptionPos = buffer.m_130135_();
        this.worldPos = buffer.m_130135_();
        this.recordId = buffer.readInt();
        this.play = buffer.readBoolean();
        this.silent = buffer.readBoolean();
    }

    public PlayContraptionJukeboxPacket(ResourceLocation level, int contraptionId, BlockPos contraptionPos, BlockPos worldPos, int recordId, boolean play, boolean silent) {
        this.level = level;
        this.contraptionId = contraptionId;
        this.contraptionPos = contraptionPos;
        this.worldPos = worldPos;
        this.recordId = recordId;
        this.play = play;
        this.silent = silent;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.level);
        buffer.writeInt(this.contraptionId);
        buffer.m_130064_(this.contraptionPos);
        buffer.m_130064_(this.worldPos);
        buffer.writeInt(this.recordId);
        buffer.writeBoolean(this.play);
        buffer.writeBoolean(this.silent);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null || !world.m_46472_().m_135782_().equals((Object)this.level)) {
                return;
            }
            if (!world.m_46749_(this.worldPos)) {
                return;
            }
            Entity entity = world.m_6815_(this.contraptionId);
            if (!(entity instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            if (this.play) {
                Item item = Item.m_41445_((int)this.recordId);
                if (!(item instanceof RecordItem)) {
                    return;
                }
                RecordItem recordItem = (RecordItem)item;
                ContraptionMusicManager.playContraptionMusic(recordItem.m_43051_(), contraptionEntity, this.contraptionPos, this.worldPos, recordItem, this.silent);
            } else {
                ContraptionMusicManager.playContraptionMusic(null, contraptionEntity, this.contraptionPos, this.worldPos, null, this.silent);
            }
        });
        return true;
    }
}

