/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.izofar.bygonenether.entity.PiglinPrisoner;
import com.izofar.bygonenether.entity.ai.behavior.ModFollowLeader;
import com.izofar.bygonenether.entity.ai.behavior.ModStartAdmiringItemIfSeen;
import com.izofar.bygonenether.entity.ai.behavior.ModStopAdmiringIfItemTooFarAway;
import com.izofar.bygonenether.entity.ai.behavior.ModStopAdmiringIfTiredOfTryingToReachItem;
import com.izofar.bygonenether.entity.ai.behavior.ModStopHoldingItemIfNoLongerAdmiring;
import com.izofar.bygonenether.init.ModEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class PiglinPrisonerAi {
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeUtil.m_145020_((int)5, (int)7);
    private static final int CELEBRATION_TIME = 200;
    private static final Predicate<PathfinderMob> isDistracted = mob -> {
        if (mob instanceof PiglinPrisoner) {
            PiglinPrisoner piglinPrisoner = (PiglinPrisoner)((Object)mob);
            Brain<PiglinPrisoner> brain = piglinPrisoner.m_6274_();
            return brain.m_21874_(MemoryModuleType.f_26332_) || brain.m_21874_(MemoryModuleType.f_26333_) || brain.m_21874_(MemoryModuleType.f_26383_) || brain.m_21952_(MemoryModuleType.f_26342_).orElse(false) != false || brain.m_21952_(MemoryModuleType.f_148198_).orElse(false) == false;
        }
        return false;
    };

    public static Brain<?> makeBrain(PiglinPrisoner piglinPrisoner, Brain<PiglinPrisoner> brain) {
        PiglinPrisonerAi.initCoreActivity(brain);
        PiglinPrisonerAi.initIdleActivity(brain);
        PiglinPrisonerAi.initAdmireItemActivity(brain);
        PiglinPrisonerAi.initFightActivity(piglinPrisoner, brain);
        PiglinPrisonerAi.initCelebrateActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<PiglinPrisoner> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)((Object)new ModFollowLeader(isDistracted)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)InteractWithDoor.m_257893_(), PiglinPrisonerAi.avoidZombified(), new ModStopHoldingItemIfNoLongerAdmiring(), new ModStartAdmiringItemIfSeen(120), (Object)StopBeingAngryIfTargetDead.m_257993_()));
    }

    private static void initIdleActivity(Brain<PiglinPrisoner> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)SetEntityLookTarget.m_257836_(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.m_257741_(AbstractPiglin::m_34667_, PiglinPrisonerAi::findNearestValidAttackTarget), PiglinPrisonerAi.avoidRepellent(), PiglinPrisonerAi.createIdleLookBehaviors(), PiglinPrisonerAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initFightActivity(PiglinPrisoner piglinPrisoner, Brain<PiglinPrisoner> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(target -> !PiglinPrisonerAi.isNearestValidAttackTarget(piglinPrisoner, target)), (Object)BehaviorBuilder.m_257845_(PiglinPrisonerAi::hasCrossbow, (OneShot)BackUpIfTooClose.m_257698_((int)5, (float)0.75f)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), (Object)new CrossbowAttack(), (Object)EraseMemoryIf.m_258093_(PiglinPrisonerAi::isNearZombified, (MemoryModuleType)MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    private static void initCelebrateActivity(Brain<PiglinPrisoner> brain) {
        brain.m_21895_(Activity.f_37989_, 10, ImmutableList.of(PiglinPrisonerAi.avoidRepellent(), (Object)SetEntityLookTarget.m_257836_(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.m_257741_(AbstractPiglin::m_34667_, PiglinPrisonerAi::findNearestValidAttackTarget), (Object)BehaviorBuilder.m_257845_(PiglinPrisoner::isDancing, (OneShot)GoToTargetLocation.m_257680_((MemoryModuleType)MemoryModuleType.f_26341_, (int)2, (float)1.0f)), (Object)BehaviorBuilder.m_257845_(PiglinPrisoner::isDancing, (OneShot)GoToTargetLocation.m_257680_((MemoryModuleType)MemoryModuleType.f_26341_, (int)4, (float)0.6f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257960_((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.f_26341_);
    }

    private static void initAdmireItemActivity(Brain<PiglinPrisoner> brain) {
        brain.m_21895_(Activity.f_37990_, 10, ImmutableList.of((Object)GoToWantedItem.m_257684_(PiglinPrisonerAi::isNotHoldingLovedItemInOffHand, (float)1.0f, (boolean)true, (int)9), new ModStopAdmiringIfItemTooFarAway(9), new ModStopAdmiringIfTiredOfTryingToReachItem(200, 200)), MemoryModuleType.f_26336_);
    }

    private static RunOne<LivingEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20511_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<PiglinPrisoner> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)EntityType.f_20511_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)8, (boolean)false);
    }

    private static BehaviorControl<PiglinPrisoner> avoidZombified() {
        return CopyMemoryWithExpiry.m_257819_(PiglinPrisonerAi::isNearZombified, (MemoryModuleType)MemoryModuleType.f_26351_, (MemoryModuleType)MemoryModuleType.f_26383_, (UniformInt)AVOID_ZOMBIFIED_DURATION);
    }

    public static void updateActivity(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37990_, (Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37989_, (Object)Activity.f_37979_));
        Activity activity1 = brain.m_21968_().orElse(null);
        if (activity != activity1) {
            PiglinPrisonerAi.getSoundForCurrentActivity(piglinPrisoner).ifPresent(piglinPrisoner::m_216990_);
        }
        piglinPrisoner.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
        if (!brain.m_21874_(MemoryModuleType.f_26341_)) {
            brain.m_21936_(MemoryModuleType.f_26342_);
        }
        piglinPrisoner.setDancing(brain.m_21874_(MemoryModuleType.f_26342_));
    }

    public static void pickUpItem(PiglinPrisoner piglinPrisoner, ItemEntity itemEntity) {
        ItemStack itemstack;
        PiglinPrisonerAi.stopWalking(piglinPrisoner);
        if (itemEntity.m_32055_().m_150930_(Items.f_42587_)) {
            piglinPrisoner.m_7938_((Entity)itemEntity, itemEntity.m_32055_().m_41613_());
            itemstack = itemEntity.m_32055_();
            itemEntity.m_146870_();
        } else {
            piglinPrisoner.m_7938_((Entity)itemEntity, 1);
            itemstack = PiglinPrisonerAi.removeOneItemFromItemEntity(itemEntity);
        }
        if (PiglinPrisonerAi.isLovedItem(itemstack)) {
            piglinPrisoner.m_6274_().m_21936_(MemoryModuleType.f_26337_);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack);
            PiglinPrisonerAi.admireGoldItem(piglinPrisoner);
        } else if (PiglinPrisonerAi.isFood(itemstack) && !PiglinPrisonerAi.hasEatenRecently(piglinPrisoner)) {
            PiglinPrisonerAi.eat(piglinPrisoner);
        } else if (piglinPrisoner.m_255207_(itemstack).m_41619_()) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        }
    }

    public static void holdInOffhand(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglinPrisoner)) {
            piglinPrisoner.m_19983_(piglinPrisoner.m_21120_(InteractionHand.OFF_HAND));
        }
        piglinPrisoner.holdInOffHand(stack);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        ItemStack itemstack1 = itemstack.m_41620_(1);
        if (itemstack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(itemstack);
        }
        return itemstack1;
    }

    public static void stopHoldingOffHandItem(PiglinPrisoner piglinPrisoner, boolean shouldThrowItems) {
        ItemStack itemstack = piglinPrisoner.m_21120_(InteractionHand.OFF_HAND);
        piglinPrisoner.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        boolean flag = itemstack.isPiglinCurrency();
        if (shouldThrowItems && flag) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        } else if (!flag) {
            boolean flag1;
            boolean bl = flag1 = !piglinPrisoner.m_255207_(itemstack).m_41619_();
            if (!flag1) {
                PiglinPrisonerAi.throwItems(piglinPrisoner, Collections.singletonList(itemstack));
            }
        }
    }

    public static void throwItems(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList) {
        Player tempter = piglinPrisoner.getTempter();
        Optional optional = piglinPrisoner.m_6274_().m_21952_(MemoryModuleType.f_26368_);
        if (tempter != null) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, tempter, stackList);
        } else if (optional.isPresent()) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, (Player)optional.get(), stackList);
        } else {
            PiglinPrisonerAi.throwItemsTowardRandomPos(piglinPrisoner, stackList);
        }
    }

    private static void throwItemsTowardRandomPos(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, PiglinPrisonerAi.getRandomNearbyPos(piglinPrisoner));
    }

    private static void throwItemsTowardPlayer(PiglinPrisoner piglinPrisoner, Player player, List<ItemStack> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, player.m_20182_());
    }

    private static void throwItemsTowardPos(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList, Vec3 vec) {
        if (!stackList.isEmpty()) {
            piglinPrisoner.m_6674_(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : stackList) {
                BehaviorUtils.m_22613_((LivingEntity)piglinPrisoner, (ItemStack)itemstack, (Vec3)vec.m_82520_(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vec3 getRandomNearbyPos(PiglinPrisoner piglinPrisoner) {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)piglinPrisoner, (int)4, (int)2);
        return vec3 == null ? piglinPrisoner.m_20182_() : vec3;
    }

    public static void cancelAdmiring(PiglinPrisoner piglinPrisoner) {
        if (PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && !piglinPrisoner.m_21206_().m_41619_()) {
            piglinPrisoner.m_19983_(piglinPrisoner.m_21206_());
            piglinPrisoner.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
    }

    public static boolean wantsToPickup(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        if (stack.m_204117_(ItemTags.f_13150_)) {
            return false;
        }
        if (PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            return false;
        }
        if (stack.isPiglinCurrency() || PiglinPrisonerAi.isLovedItem(stack)) {
            return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner);
        }
        boolean flag = piglinPrisoner.canAddToInventory(stack);
        if (stack.m_150930_(Items.f_42587_)) {
            return flag;
        }
        if (!PiglinPrisonerAi.isLovedItem(stack)) {
            return piglinPrisoner.canReplaceCurrentItem(stack);
        }
        return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner) && flag;
    }

    public static boolean isLovedItem(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13151_);
    }

    private static boolean isNearestValidAttackTarget(PiglinPrisoner piglinPrisoner, LivingEntity target) {
        return PiglinPrisonerAi.findNearestValidAttackTarget(piglinPrisoner).filter(potentialTarget -> potentialTarget == target).isPresent();
    }

    private static boolean isNearZombified(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26351_)) {
            LivingEntity livingentity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26351_).get();
            return piglinPrisoner.m_19950_((Entity)livingentity, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.m_6274_();
        if (PiglinPrisonerAi.isNearZombified(piglinPrisoner)) {
            return Optional.empty();
        }
        Optional optional = BehaviorUtils.m_22610_((LivingEntity)piglinPrisoner, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (optional.isPresent() && Sensor.m_182377_((LivingEntity)piglinPrisoner, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional optional1 = brain.m_21952_(MemoryModuleType.f_26333_);
        if (optional1.isPresent()) {
            return optional1;
        }
        return Optional.empty();
    }

    public static InteractionResult mobInteract(PiglinPrisoner piglinPrisoner, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (PiglinPrisonerAi.canAdmire(piglinPrisoner, itemstack)) {
            ItemStack itemstack1 = itemstack.m_41620_(1);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack1);
            if (!player.equals((Object)piglinPrisoner.getTempter())) {
                PiglinPrisonerAi.newTemptingPlayer(piglinPrisoner, player);
            }
            PiglinPrisonerAi.admireGoldItem(piglinPrisoner);
            PiglinPrisonerAi.stopWalking(piglinPrisoner);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAdmire(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        return !PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && !PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && (stack.isPiglinCurrency() || PiglinPrisonerAi.isLovedItem(stack));
    }

    public static void wasHurtBy(PiglinPrisoner piglin, LivingEntity attacker) {
        if (attacker instanceof Piglin) {
            return;
        }
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglin)) {
            PiglinPrisonerAi.stopHoldingOffHandItem(piglin, false);
        }
        Brain<PiglinPrisoner> brain = piglin.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26341_);
        brain.m_21936_(MemoryModuleType.f_26342_);
        brain.m_21936_(MemoryModuleType.f_26336_);
        if (attacker instanceof Player) {
            brain.m_21882_(MemoryModuleType.f_26339_, (Object)true, 400L);
        }
        PiglinPrisonerAi.getAvoidTarget(piglin).ifPresent(target -> {
            if (target.m_6095_() != attacker.m_6095_()) {
                brain.m_21936_(MemoryModuleType.f_26383_);
            }
        });
        PiglinPrisonerAi.maybeRetaliate(piglin, attacker);
    }

    protected static void maybeRetaliate(AbstractPiglin piglin, LivingEntity target) {
        if (!piglin.m_6274_().m_21954_(Activity.f_37991_) && Sensor.m_182377_((LivingEntity)piglin, (LivingEntity)target) && !BehaviorUtils.m_22598_((LivingEntity)piglin, (LivingEntity)target, (double)4.0) && target.m_6095_() != EntityType.f_20532_) {
            PiglinPrisonerAi.setAngerTarget(piglin, target);
            PiglinPrisonerAi.broadcastAngerTarget(piglin, target);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21968_().map(activity -> PiglinPrisonerAi.getSoundForActivity(piglinPrisoner, activity));
    }

    private static SoundEvent getSoundForActivity(PiglinPrisoner piglinPrisoner, Activity activity) {
        if (activity == Activity.f_37988_) {
            return SoundEvents.f_12240_;
        }
        if (piglinPrisoner.m_34666_()) {
            return SoundEvents.f_12245_;
        }
        if (activity == Activity.f_37991_ && PiglinPrisonerAi.isNearAvoidTarget(piglinPrisoner)) {
            return SoundEvents.f_12245_;
        }
        if (activity == Activity.f_37990_) {
            return SoundEvents.f_12238_;
        }
        if (activity == Activity.f_37989_) {
            return SoundEvents.f_12241_;
        }
        if (PiglinPrisonerAi.seesPlayerHoldingLovedItem(piglinPrisoner)) {
            return SoundEvents.f_12243_;
        }
        return PiglinPrisonerAi.isNearRepellent(piglinPrisoner) ? SoundEvents.f_12245_ : SoundEvents.f_12239_;
    }

    private static boolean isNearAvoidTarget(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.m_6274_();
        return brain.m_21874_(MemoryModuleType.f_26383_) && ((LivingEntity)brain.m_21952_(MemoryModuleType.f_26383_).get()).m_19950_((Entity)piglinPrisoner, 12.0);
    }

    private static void stopWalking(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        piglinPrisoner.m_21573_().m_26573_();
    }

    public static void setAngerTarget(AbstractPiglin piglin, LivingEntity target) {
        if (Sensor.m_182377_((LivingEntity)piglin, (LivingEntity)target)) {
            piglin.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            piglin.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), 600L);
        }
    }

    private static boolean isNearRepellent(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26356_);
    }

    public static void exciteNearbyPiglins(Player player, boolean requireVisibility) {
        List list = player.m_9236_().m_45976_(PiglinPrisoner.class, player.m_20191_().m_82400_(16.0));
        list.stream().filter(PiglinAi::m_34942_).filter(piglin -> !requireVisibility || BehaviorUtils.m_22667_((LivingEntity)piglin, (LivingEntity)player)).forEach(PiglinPrisonerAi::startDancing);
    }

    public static void startDancing(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.m_6274_().m_21882_(MemoryModuleType.f_26342_, (Object)true, 200L);
        piglinPrisoner.m_6274_().m_21882_(MemoryModuleType.f_26341_, (Object)piglinPrisoner.m_20183_(), 200L);
    }

    private static void startDancing(Piglin piglin) {
        piglin.m_6274_().m_21882_(MemoryModuleType.f_26342_, (Object)true, 200L);
        piglin.m_6274_().m_21882_(MemoryModuleType.f_26341_, (Object)piglin.m_20183_(), 200L);
    }

    private static boolean seesPlayerHoldingLovedItem(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26354_);
    }

    private static boolean isHoldingItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return !piglinPrisoner.m_21206_().m_41619_();
    }

    private static void admireGoldItem(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, 120L);
    }

    private static void putInInventory(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        piglinPrisoner.addToInventory(stack);
        PiglinPrisonerAi.giveGoldBuff(piglinPrisoner);
        PiglinPrisonerAi.pledgeAllegiance(piglinPrisoner);
    }

    private static boolean hasCrossbow(LivingEntity livingentity) {
        return livingentity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    protected static void broadcastAngerTarget(AbstractPiglin piglin, LivingEntity target) {
        PiglinPrisonerAi.getAdultAbstractPiglins(piglin).forEach(adultPiglin -> PiglinPrisonerAi.setAngerTargetIfCloserThanCurrent(adultPiglin, target));
    }

    public static void broadcastBeingRescued(AbstractPiglin piglin) {
        PiglinPrisonerAi.getAdultPiglins(piglin).forEach(PiglinPrisonerAi::startDancing);
    }

    private static List<AbstractPiglin> getAdultAbstractPiglins(AbstractPiglin piglin) {
        return (List)piglin.m_6274_().m_21952_(MemoryModuleType.f_26346_).orElse(ImmutableList.of());
    }

    private static List<Piglin> getAdultPiglins(AbstractPiglin piglin) {
        return ((List)piglin.m_6274_().m_21952_(MemoryModuleType.f_26346_).orElse(ImmutableList.of())).stream().filter(abstractPiglin -> abstractPiglin instanceof Piglin).map(abstractPiglin -> (Piglin)abstractPiglin).toList();
    }

    private static void setAngerTargetIfCloserThanCurrent(AbstractPiglin piglin, LivingEntity target) {
        Optional<LivingEntity> optional = PiglinPrisonerAi.getAngerTarget(piglin);
        LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)piglin, optional, (LivingEntity)target);
        if (optional.isEmpty() || optional.get() != livingentity) {
            PiglinPrisonerAi.setAngerTarget(piglin, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglin piglin) {
        return BehaviorUtils.m_22610_((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.f_26334_);
    }

    private static boolean isNotHoldingLovedItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_21206_().m_41619_() || !PiglinPrisonerAi.isLovedItem(piglinPrisoner.m_21206_());
    }

    private static boolean isAdmiringItem(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26336_);
    }

    private static boolean isAdmiringDisabled(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26339_);
    }

    public static Optional<LivingEntity> getAvoidTarget(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26383_) ? piglinPrisoner.m_6274_().m_21952_(MemoryModuleType.f_26383_) : Optional.empty();
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity player) {
        return player.m_6095_() == EntityType.f_20532_ && player.m_21093_(PiglinPrisonerAi::isLovedItem);
    }

    private static boolean isFood(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_144310_);
    }

    private static void eat(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.m_6274_().m_21882_(MemoryModuleType.f_26355_, (Object)true, 200L);
    }

    private static boolean hasEatenRecently(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_26355_);
    }

    private static void giveGoldBuff(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 10800, 3, false, true));
        piglinPrisoner.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 7200, 1, false, false));
    }

    private static void newTemptingPlayer(PiglinPrisoner piglinPrisoner, Player player) {
        piglinPrisoner.m_6274_().m_21879_(MemoryModuleType.f_148196_, (Object)player);
        piglinPrisoner.m_6274_().m_21879_(MemoryModuleType.f_148198_, (Object)false);
        piglinPrisoner.setTempterUUID(player.m_20148_());
    }

    protected static void pledgeAllegiance(PiglinPrisoner piglinPrisoner) {
        if (piglinPrisoner.m_6274_().m_21874_(MemoryModuleType.f_148196_)) {
            piglinPrisoner.m_6274_().m_21879_(MemoryModuleType.f_148198_, (Object)true);
        }
    }

    public static void reloadAllegiance(PiglinPrisoner piglinPrisoner, Player player) {
        piglinPrisoner.m_6274_().m_21879_(MemoryModuleType.f_148196_, (Object)player);
        piglinPrisoner.m_6274_().m_21879_(MemoryModuleType.f_148198_, (Object)true);
    }
}

