/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.api.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.HoldUpModes;
import dev.tr7zw.transition.mc.EntityUtil;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.ItemUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LookAtItemAnimation
extends BasicAnimation {
    private Set<Item> holdingItems = new HashSet<Item>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEABaseMod.config.holdUpItemsMode != HoldUpModes.NONE && !this.holdingItems.isEmpty();
    }

    private void bind() {
        this.holdingItems.clear();
        Item invalid = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)"minecraft", (String)"air"));
        for (String itemId : NEABaseMod.config.holdingItems) {
            try {
                Item item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)itemId.split(":")[0], (String)itemId.split(":")[1]));
                if (invalid == item) continue;
                this.holdingItems.add(item);
            }
            catch (Exception ex) {
                NEABaseMod.LOGGER.info("Unknown item to add to the holding list: " + itemId);
            }
        }
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        boolean leftArm;
        if (NEABaseMod.config.holdUpOnlySelf && entity != Minecraft.m_91087_().f_91074_) {
            return false;
        }
        boolean allItems = NEABaseMod.config.holdUpItemsMode == HoldUpModes.ALL;
        ItemStack itemInRightHand = entity.m_21120_(entity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        ItemStack itemInLeftHand = entity.m_21120_(entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        boolean rightArm = this.holdingItems.contains(itemInRightHand.m_41720_()) || allItems && !itemInRightHand.m_41619_() && (!entity.f_20911_ || entity.m_5737_() != HumanoidArm.RIGHT);
        boolean bl = leftArm = this.holdingItems.contains(itemInLeftHand.m_41720_()) || allItems && !itemInLeftHand.m_41619_() && (!entity.f_20911_ || entity.m_5737_() != HumanoidArm.LEFT);
        if (rightArm && leftArm && !entity.f_20911_) {
            this.target = this.bothHands;
            return true;
        }
        if (rightArm && (!entity.f_20911_ || entity.f_20912_ != (entity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            this.target = this.right;
            return true;
        }
        if (leftArm && (!entity.f_20911_ || entity.f_20912_ != (entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            this.target = this.left;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel model, BodyPart part, float delta, float tickCounter) {
        HumanoidArm arm = part == BodyPart.LEFT_ARM ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        switch (NEABaseMod.config.holdUpTarget) {
            case NONE: {
                AnimationUtil.applyArmTransforms(model, arm, -NEABaseMod.config.holdUpItemOffset - Mth.m_14179_((float)(-1.0f * (EntityUtil.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)1.0f, (float)1.5f), -0.2f, 0.3f);
                break;
            }
            case CAMERA: {
                float invert = part == BodyPart.LEFT_ARM ? -1.0f : 1.0f;
                AnimationUtil.applyArmTransforms(model, arm, Mth.m_14036_((float)(-1.5707964f + model.f_102808_.f_104203_), (float)-2.5f, (float)0.0f), Mth.m_14036_((float)(NEABaseMod.config.holdUpCameraOffset + model.f_102808_.f_104204_ * invert), (float)-0.2f, (float)Math.max(0.2f, NEABaseMod.config.holdUpCameraOffset)), 0.1f);
            }
        }
    }
}

