/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.CasingConnectivity;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import fr.iglee42.createcasing.config.CCStress;
import fr.iglee42.createcasing.registries.EncasedBlockStateGens;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ItemModelBuilder;

public class CasingBuilderTransformers {
    public static <B extends EncasedShaftBlock, P, E extends Block> NonNullUnaryOperator<BlockBuilder<B, P>> encasedShaft(BlockEntry<E> shaft, String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        String sId = shaft.getId().m_135815_().replace("_shaft", "");
        if (shaft.equals((Object)AllBlocks.SHAFT)) {
            sId = "normal";
        }
        String finalSId = sId;
        return builder -> {
            BlockBuilder b = (BlockBuilder)CasingBuilderTransformers.encasedBase(builder, () -> ((BlockEntry)shaft).get()).blockstate(EncasedBlockStateGens.encasedShaft(finalSId, casing)).item().model((ctx, prov) -> ((ItemModelBuilder)prov.getBuilder(ctx.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.encasedShaftModel((RegistrateProvider)prov, finalSId, casing, true)))).build();
            if (casingShift.get() != null) {
                b = (BlockBuilder)((BlockBuilder)b.onRegister(CreateRegistrate.connectedTextures(() -> CasingBuilderTransformers.lambda$encasedShaft$1((Supplier)casingShift)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> CasingBuilderTransformers.lambda$encasedShaft$3((Supplier)casingShift, arg_0, arg_1)));
            }
            return b;
        };
    }

    public static <B extends CasingBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> casing(Supplier<CTSpriteShiftEntry> ct) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_)).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> CasingBuilderTransformers.lambda$casing$6((Supplier)ct)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> CasingBuilderTransformers.lambda$casing$7((Supplier)ct, arg_0, arg_1)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build();
    }

    public static <B extends EncasedCogwheelBlock, P, E extends Block> NonNullUnaryOperator<BlockBuilder<B, P>> encasedCogwheel(BlockEntry<E> cogwheel, String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        String sId = cogwheel.getId().m_135815_().replace("_cogwheel", "");
        if (cogwheel.equals((Object)AllBlocks.COGWHEEL)) {
            sId = "normal";
        }
        String finalSId = sId;
        return b -> CasingBuilderTransformers.encasedCogwheelBase(b, finalSId, casing, casingShift, () -> ((BlockEntry)cogwheel).get(), false);
    }

    public static <B extends EncasedCogwheelBlock, P, E extends Block> NonNullUnaryOperator<BlockBuilder<B, P>> encasedLargeCogwheel(BlockEntry<E> cogwheel, String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        String sId = cogwheel.getId().m_135815_().replace("_large_cogwheel", "");
        if (cogwheel.equals((Object)AllBlocks.LARGE_COGWHEEL)) {
            sId = "normal";
        }
        String finalSId = sId;
        return b -> {
            BlockBuilder builder = CasingBuilderTransformers.encasedCogwheelBase(b, finalSId, casing, casingShift, () -> ((BlockEntry)cogwheel).get(), true);
            if (casingShift.get() != null) {
                builder = (BlockBuilder)builder.onRegister(CreateRegistrate.connectedTextures(() -> CasingBuilderTransformers.lambda$encasedLargeCogwheel$10((Supplier)casingShift)));
            }
            return builder;
        };
    }

    private static <B extends EncasedCogwheelBlock, P> BlockBuilder<B, P> encasedCogwheelBase(BlockBuilder<B, P> b, String cogwheel, String casing, Supplier<CTSpriteShiftEntry> casingShift, Supplier<ItemLike> drop, boolean large) {
        BlockBuilder builder = (BlockBuilder)CasingBuilderTransformers.encasedBase(b, drop).addLayer(() -> RenderType::m_110457_).blockstate(large ? EncasedBlockStateGens.encasedLargeCogwheel(cogwheel, casing) : EncasedBlockStateGens.encasedCogwheel(cogwheel, casing)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder(ctx.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.encasedCogwheelModel((RegistrateProvider)prov, casing, cogwheel, null, large)))).texture(large ? "4" : "1_2", large ? EncasedBlockStateGens.getLargeCogwheelTexture(cogwheel) : EncasedBlockStateGens.getCogwheelTexture(cogwheel))).build();
        if (casingShift != null) {
            builder = (BlockBuilder)builder.onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() == s.m_61143_((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false)));
        }
        return builder;
    }

    private static <B extends RotatedPillarKineticBlock, P> BlockBuilder<B, P> encasedBase(BlockBuilder<B, P> b, Supplier<ItemLike> drop) {
        return ((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).transform(CCStress.setNoImpact())).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)drop.get()));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedLargeCogwheel$10(Supplier casingShift) {
        return new EncasedCogCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }

    private static /* synthetic */ void lambda$casing$7(Supplier ct, CasingBlock block, CasingConnectivity cc) {
        cc.makeCasing((Block)block, (CTSpriteShiftEntry)ct.get());
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$casing$6(Supplier ct) {
        return new EncasedCTBehaviour((CTSpriteShiftEntry)ct.get());
    }

    private static /* synthetic */ void lambda$encasedShaft$3(Supplier casingShift, EncasedShaftBlock block, CasingConnectivity cc) {
        cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() != s.m_61143_((Property)EncasedShaftBlock.AXIS));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedShaft$1(Supplier casingShift) {
        return new EncasedCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }
}

