/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities;

import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import fr.iglee42.createcasing.blockEntities.MetalShaftBlockEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BrassShaftBlockEntity
extends MetalShaftBlockEntity {
    public static int BASE_STRESS = 1024;
    protected int configuredStress = BASE_STRESS;
    protected Mode mode = Mode.USED_STRESS;
    protected Operation operation = Operation.GREATER;

    public BrassShaftBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            switch (this.mode) {
                case USED_STRESS: {
                    if (!this.operation.isValid((int)this.stress, this.configuredStress)) break;
                    RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.m_58899_(), (KineticBlockEntity)this);
                    break;
                }
                case REMAINING_STRESS: {
                    if (!this.operation.isValid((int)(this.capacity - this.stress), this.configuredStress)) break;
                    RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.m_58899_(), (KineticBlockEntity)this);
                    break;
                }
                case MAX_STRESS: {
                    if (!this.operation.isValid((int)this.capacity, this.configuredStress)) break;
                    RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.m_58899_(), (KineticBlockEntity)this);
                }
            }
        }
    }

    public float getCapacity() {
        return this.capacity;
    }

    public int getMaxSupportedStress() {
        return this.configuredStress;
    }

    public void setMaxSupportedStress(int stress) {
        this.configuredStress = stress;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public float getStress() {
        return this.stress;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("configuredStress", this.configuredStress);
        compound.m_128359_("mode", this.mode.m_7912_());
        compound.m_128359_("operation", this.operation.m_7912_());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.configuredStress = compound.m_128451_("configuredStress");
        this.mode = Mode.byName(compound.m_128461_("mode"));
        this.operation = Operation.byName(compound.m_128461_("operation"));
        super.read(compound, clientPacket);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public static enum Mode implements StringRepresentable
    {
        USED_STRESS,
        REMAINING_STRESS,
        MAX_STRESS;


        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public static List<? extends Component> getComponents() {
            return Arrays.stream(Mode.values()).map(m -> "createcasing.brass_shaft.mode." + m.m_7912_()).map(Component::m_237115_).toList();
        }

        public static Mode byId(int mode) {
            return Arrays.stream(Mode.values()).filter(m -> m.ordinal() == mode).findFirst().orElse(USED_STRESS);
        }

        public static Mode byName(String mode) {
            return Arrays.stream(Mode.values()).filter(m -> m.m_7912_().equals(mode)).findFirst().orElse(USED_STRESS);
        }
    }

    public static enum Operation implements StringRepresentable
    {
        LESS((stress, capacity) -> stress < capacity),
        EQUALS(Objects::equals),
        GREATER((stress, capacity) -> stress > capacity);

        final BiPredicate<Integer, Integer> isTrue;

        private Operation(BiPredicate<Integer, Integer> isTrue) {
            this.isTrue = isTrue;
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public static List<? extends Component> getComponents() {
            return Arrays.stream(Operation.values()).map(m -> "createcasing.brass_shaft.operation." + m.m_7912_()).map(Component::m_237115_).toList();
        }

        public static Operation byId(int mode) {
            return Arrays.stream(Operation.values()).filter(m -> m.ordinal() == mode).findFirst().orElse(GREATER);
        }

        public static Operation byName(String mode) {
            return Arrays.stream(Operation.values()).filter(m -> m.m_7912_().equals(mode)).findFirst().orElse(GREATER);
        }

        public boolean isValid(int stress, int capacity) {
            return this.isTrue.test(stress, capacity);
        }
    }
}

