/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.api;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.logistics.depot.MountedDepotInteractionBehaviour;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createcasing.api.ApiBuilderTransformers;
import fr.iglee42.createcasing.api.blocks.ApiCogwheelBlock;
import fr.iglee42.createcasing.api.blocks.ApiDepotBlock;
import fr.iglee42.createcasing.api.blocks.ApiGearboxBlock;
import fr.iglee42.createcasing.api.blocks.ApiMixerBlock;
import fr.iglee42.createcasing.api.blocks.ApiPressBlock;
import fr.iglee42.createcasing.api.items.ApiCogwheelBlockItem;
import fr.iglee42.createcasing.api.items.ApiVerticalGearboxItem;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedPipeBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedShaftBlock;
import fr.iglee42.createcasing.config.CCStress;
import fr.iglee42.createcasing.registries.EncasedBlocks;
import fr.iglee42.createcasing.utils.Deferred;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class CreateCasingApi {
    public static BlockEntry<CasingBlock> createCasing(CreateRegistrate registrate, String name, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)registrate.block(name + "_casing", CasingBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.casing(() -> connectedTexturesSprite))).register();
    }

    public static BlockEntry<PublicEncasedShaftBlock> createEncasedShaft(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_shaft", p -> new PublicEncasedShaftBlock((BlockBehaviour.Properties)p, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(ApiBuilderTransformers.encasedShaft(name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.SHAFT))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedCogwheelBlock> createEncasedCogwheel(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite, CTSpriteShiftEntry verticalCogwheelSide, CTSpriteShiftEntry horizontalCogwheelSide) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(ApiBuilderTransformers.encasedCogwheel(name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.COGWHEEL))).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(connectedTexturesSprite, Couple.create((Object)verticalCogwheelSide, (Object)horizontalCogwheelSide))))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedCogwheelBlock> createEncasedLargeCogwheel(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_large_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(ApiBuilderTransformers.encasedLargeCogwheel(name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.LARGE_COGWHEEL))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedPipeBlock> createEncasedPipe(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, casing)).initialProperties(SharedProperties::copperMetal).properties(p -> p.m_284180_(MapColor.f_283907_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.encasedPipe()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> (Boolean)s.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false)))).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::withAO))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).register();
    }

    public static BlockEntry<ApiGearboxBlock> createGearbox(CreateRegistrate registrate, String name, CTSpriteShiftEntry connectedTexturesSprite, boolean shouldGenerateVerticalItem) {
        if (shouldGenerateVerticalItem) {
            Deferred<ItemEntry> itemEntryDeferred = new Deferred<ItemEntry>();
            BlockEntry gearbox = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_gearbox", p -> new ApiGearboxBlock((BlockBehaviour.Properties)p, (Deferred<ItemEntry<ApiVerticalGearboxItem>>)itemEntryDeferred)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
            itemEntryDeferred.set(registrate.item("vertical_" + name + "_gearbox", p -> new ApiVerticalGearboxItem((Item.Properties)p, (Block)gearbox.get())).model(AssetLookup.customBlockItemModel((String[])new String[]{name + "_gearbox", "item_vertical"})).register());
            return gearbox;
        }
        BlockEntry gearbox = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_gearbox", p -> new ApiGearboxBlock((BlockBehaviour.Properties)p, null)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
        return gearbox;
    }

    public static BlockEntry<ApiDepotBlock> createDepot(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_depot", ApiDepotBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283818_)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).transform((NonNullFunction)DisplaySource.displaySource((RegistryEntry)AllDisplaySources.ITEM_NAMES))).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new MountedDepotInteractionBehaviour()))).transform((NonNullFunction)MountedItemStorageType.mountedItemStorage((RegistryEntry)AllMountedStorageTypes.DEPOT))).item().transform(ModelGen.customItemModel((String[])new String[]{"_", "block"}))).register();
    }

    public static BlockEntry<ApiMixerBlock> createMixer(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_mixer", ApiMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283947_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).addLayer(() -> RenderType::m_110457_).transform(CCStress.setImpact(4.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    public static BlockEntry<ApiPressBlock> createPress(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_press", ApiPressBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_60955_().m_284180_(MapColor.f_283819_)).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.horizontalBlockProvider((boolean)true)).transform(CCStress.setImpact(8.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    public static BlockEntry<ApiCogwheelBlock> createSmallCogwheel(CreateRegistrate registrate, String name, PartialModel partialModel) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_cogwheel", p -> ApiCogwheelBlock.small(p, partialModel)).initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283762_)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(ApiCogwheelBlockItem::new).build()).register();
    }

    public static BlockEntry<ApiCogwheelBlock> createLargeCogwheel(CreateRegistrate registrate, String name, PartialModel partialModel) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_large_cogwheel", p -> ApiCogwheelBlock.large(p, partialModel)).initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283762_)).transform(TagGen.axeOrPickaxe())).transform(CCStress.setNoImpact())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(ApiCogwheelBlockItem::new).build()).register();
    }

    public static void forCustomShafts(Consumer<BlockEntry<? extends ShaftBlock>> action) {
        EncasedBlocks.forEachShaft(action);
    }
}

