/*
 * Decompiled with CFR 0.152.
 */
package net.steampn.createhorsepower.datagen;

import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.steampn.createhorsepower.CreateHorsePower;
import net.steampn.createhorsepower.client.ponders.HorseCrankPonderPlugin;
import net.steampn.createhorsepower.datagen.CHPBlockTagGenerator;
import net.steampn.createhorsepower.datagen.CHPItemTagGenerator;
import net.steampn.createhorsepower.datagen.CHPRecipeProvider;

@Mod.EventBusSubscriber(modid="createhorsepower", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new CHPRecipeProvider(packOutput));
        CHPBlockTagGenerator blockTagGenerator = (CHPBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new CHPBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CHPItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        CreateHorsePower.CREATE_REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            DataGenerators.providePonderLang(langConsumer);
        });
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new HorseCrankPonderPlugin());
        PonderIndex.getLangAccess().provideLang("createhorsepower", consumer);
    }
}

