/*
 * Decompiled with CFR 0.152.
 */
package net.steampn.createhorsepower.config;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="createhorsepower", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_WORKERS = "workers";
    private static final String CATEGORY_PATHS = "paths";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue BASE_CREATURE_RPM;
    private static final ForgeConfigSpec.IntValue SMALL_CREATURE_STRESS;
    private static final ForgeConfigSpec.IntValue MEDIUM_CREATURE_STRESS;
    private static final ForgeConfigSpec.IntValue LARGE_CREATURE_STRESS;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> SMALL_CREATURES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MEDIUM_CREATURES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> LARGE_CREATURES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> POOR_PATH;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> NORMAL_PATH;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> GREAT_PATH;
    public static final ForgeConfigSpec SPEC;
    public static int base_creature_rpm;
    public static int small_creature_stress;
    public static int medium_creature_stress;
    public static int large_creature_stress;
    public static Set<ResourceLocation> small_mobs;
    public static Set<ResourceLocation> medium_mobs;
    public static Set<ResourceLocation> large_mobs;
    public static Set<Block> poor_path;
    public static Set<Block> normal_path;
    public static Set<Block> great_path;

    private static boolean validateMobName(Object obj) {
        String mobName;
        return obj instanceof String && ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(mobName = (String)obj));
    }

    private static boolean validateBlockName(Object obj) {
        String blockName;
        return obj instanceof String && ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        LOGGER.info("Create Horse Power config has been loaded!");
        base_creature_rpm = (Integer)BASE_CREATURE_RPM.get();
        small_creature_stress = (Integer)SMALL_CREATURE_STRESS.get();
        medium_creature_stress = (Integer)MEDIUM_CREATURE_STRESS.get();
        large_creature_stress = (Integer)LARGE_CREATURE_STRESS.get();
        small_mobs = ((List)SMALL_CREATURES.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        medium_mobs = ((List)MEDIUM_CREATURES.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        large_mobs = ((List)LARGE_CREATURES.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        poor_path = ((List)POOR_PATH.get()).stream().map(pathName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(pathName))).collect(Collectors.toSet());
        normal_path = ((List)NORMAL_PATH.get()).stream().map(pathName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(pathName))).collect(Collectors.toSet());
        great_path = ((List)GREAT_PATH.get()).stream().map(pathName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(pathName))).collect(Collectors.toSet());
    }

    static {
        COMMON_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        BASE_CREATURE_RPM = COMMON_BUILDER.comment("Base rpm creatures can spin the horse crank.").defineInRange("creatureRPMRange", 16, 1, Integer.MAX_VALUE);
        SMALL_CREATURE_STRESS = COMMON_BUILDER.comment("How much stress small creatures can produce for the horse crank.").defineInRange("smallCreatureStressRange", 128, 1, Integer.MAX_VALUE);
        MEDIUM_CREATURE_STRESS = COMMON_BUILDER.comment("How much stress medium creatures can produce for the horse crank.").defineInRange("mediumCreatureStressRange", 256, 1, Integer.MAX_VALUE);
        LARGE_CREATURE_STRESS = COMMON_BUILDER.comment("How much stress large creatures can produce for the horse crank.").defineInRange("largeCreatureStressRange", 512, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Path Category").push(CATEGORY_PATHS);
        POOR_PATH = COMMON_BUILDER.comment("Types of blocks valid as \"Poor\" quality,").worldRestart().defineList("poor_path_block", List.of("minecraft:dirt", "minecraft:grass_block"), Config::validateBlockName);
        NORMAL_PATH = COMMON_BUILDER.comment("Types of blocks valid as \"Normal\" quality,").worldRestart().defineList("normal_path_block", List.of("minecraft:dirt_path", "minecraft:gravel"), Config::validateBlockName);
        GREAT_PATH = COMMON_BUILDER.comment("Types of blocks valid as \"Great\" quality,").worldRestart().defineList("great_path_block", List.of("minecraft:ice", "minecraft:packed_ice", "minecraft:blue_ice"), Config::validateBlockName);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Creature Category").push(CATEGORY_WORKERS);
        SMALL_CREATURES = COMMON_BUILDER.comment("Valid \"Small\" creatures").worldRestart().defineList("small_creatures", List.of("minecraft:wolf"), Config::validateMobName);
        MEDIUM_CREATURES = COMMON_BUILDER.comment("Valid \"Medium\" creatures").worldRestart().defineList("medium_creatures", List.of("minecraft:cow"), Config::validateMobName);
        LARGE_CREATURES = COMMON_BUILDER.comment("Valid \"Large\" creatures").worldRestart().defineList("large_creatures", List.of("minecraft:horse"), Config::validateMobName);
        SPEC = COMMON_BUILDER.build();
    }
}

