/*
 * Decompiled with CFR 0.152.
 */
package net.steampn.createhorsepower.blocks.horse_crank;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.steampn.createhorsepower.blocks.horse_crank.HorseCrankBlock;
import net.steampn.createhorsepower.config.Config;
import org.slf4j.Logger;

public class HorseCrankTileEntity
extends GeneratingKineticBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TICKS_PER_BLOCK_UPDATE = 40;
    private static final int TICKS_PER_WORKER_UPDATE = 200;
    private static final BlockPos[] OFFSETS = HorseCrankTileEntity.generateOffsets();
    public boolean hasValidWorkingBlocks = false;
    private float rpmModifier = 0.0f;
    private Block[] cachedSurroundingBlocks;
    private PathfinderMob cachedWorkerMob;
    private long lastBlockUpdateTick = -1L;
    private long lastWorkerUpdateTick = -1L;
    private float lastGeneratedSpeed = 0.0f;
    public float generatedSpeed = 4.0f;
    private float lastSpeed = 0.0f;

    public HorseCrankTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private static BlockPos[] generateOffsets() {
        ArrayList<BlockPos> offsets = new ArrayList<BlockPos>();
        for (int z = -3; z <= 3; ++z) {
            for (int x = -3; x <= 3; ++x) {
                if (x == 0 && z == 0) continue;
                offsets.add(new BlockPos(x, -1, z));
            }
        }
        return offsets.toArray(new BlockPos[0]);
    }

    public float getGeneratedSpeed() {
        return (Boolean)this.m_58900_().m_61143_((Property)HorseCrankBlock.HAS_WORKER) == false ? 0.0f : this.generatedSpeed * this.rpmModifier;
    }

    public float calculateAddedStressCapacity() {
        BlockState state = this.m_58900_();
        if (this.getGeneratedSpeed() == 0.0f || !((Boolean)state.m_61143_((Property)HorseCrankBlock.HAS_WORKER)).booleanValue()) {
            return 0.0f;
        }
        float capacity = 0.0f;
        if (((Boolean)state.m_61143_((Property)HorseCrankBlock.SMALL_WORKER_STATE)).booleanValue()) {
            capacity = Config.small_creature_stress;
        } else if (((Boolean)state.m_61143_((Property)HorseCrankBlock.MEDIUM_WORKER_STATE)).booleanValue()) {
            capacity = Config.medium_creature_stress;
        } else if (((Boolean)state.m_61143_((Property)HorseCrankBlock.LARGE_WORKER_STATE)).booleanValue()) {
            capacity = Config.large_creature_stress;
        }
        this.lastCapacityProvided = capacity = Math.abs(capacity / Math.abs(this.getGeneratedSpeed()));
        return capacity;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(2.0);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("RpmModifier", this.rpmModifier);
        compound.m_128350_("GeneratedSpeed", this.generatedSpeed);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("RpmModifier")) {
            this.rpmModifier = compound.m_128457_("RpmModifier");
        }
        if (compound.m_128441_("GeneratedSpeed")) {
            this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        Block[] blockTypeGrid = this.getValidSurroundingPathBlocks();
        Set<Block> blockSet = this.surroundingValidBlocksSet(blockTypeGrid);
        if (blockSet.contains(null)) {
            this.hasValidWorkingBlocks = false;
            if (this.lastCapacityProvided != 0.0f) {
                this.updateAnimation();
            }
            return;
        }
        this.adjustRPMModifier(blockSet);
        this.moveWorkerTo((Mob)this.getWorkerMob());
        this.updateAnimation();
    }

    private PathfinderMob getMob(List<PathfinderMob> mobsNearCrank) {
        Stream<PathfinderMob> mobsAttachedToCrank = mobsNearCrank.stream().filter(mob -> mob.m_21523_() && mob.m_21524_() instanceof LeashFenceKnotEntity && this.isBlockPosEqual(mob.m_21524_().m_20183_(), this.m_58899_()));
        List<PathfinderMob> mobs = mobsAttachedToCrank.toList();
        return mobs.isEmpty() ? null : mobs.get(0);
    }

    private boolean isBlockPosEqual(BlockPos pos1, BlockPos pos2) {
        return pos1.m_123341_() == pos2.m_123341_() && pos1.m_123342_() == pos2.m_123342_() && pos1.m_123343_() == pos2.m_123343_();
    }

    private PathfinderMob getWorkerMob() {
        if (this.lastWorkerUpdateTick > this.f_58857_.m_46467_() - 200L && this.cachedWorkerMob != null && this.cachedWorkerMob.m_6084_() && this.cachedWorkerMob.m_21523_() && this.cachedWorkerMob.m_21524_() != null && this.cachedWorkerMob.m_21524_() instanceof LeashFenceKnotEntity && this.isBlockPosEqual(this.cachedWorkerMob.m_21524_().m_20183_(), this.m_58899_())) {
            return this.cachedWorkerMob;
        }
        List mobsNearCrank = this.f_58857_.m_45976_(PathfinderMob.class, new AABB(this.m_58899_()).m_82400_(8.0));
        this.cachedWorkerMob = this.getMob(mobsNearCrank);
        this.lastWorkerUpdateTick = this.f_58857_.m_46467_();
        return this.cachedWorkerMob;
    }

    private void moveWorkerTo(Mob worker) {
        if (worker == null) {
            return;
        }
        if (worker instanceof Horse && ((Horse)worker).m_30617_()) {
            ((Horse)worker).m_30661_(false);
        }
        double baseRadius = 3.0;
        double sizeFactor = Math.max(0.8, 1.0 - ((double)worker.m_20205_() - 0.5));
        double radius = baseRadius * sizeFactor;
        int ticksPerRotation = (int)(200.0 * this.getTickSpeedModifier());
        BlockPos pos = this.m_58899_();
        double bx = pos.m_123341_();
        double by = pos.m_123342_();
        double bz = pos.m_123343_();
        bx += 0.5;
        bz += 0.5;
        double distanceToWorker = worker.m_20238_(pos.m_252807_());
        if (distanceToWorker <= radius * radius + 20.5) {
            double progress = (double)(worker.m_9236_().m_46467_() % (long)ticksPerRotation) / (double)ticksPerRotation;
            double currentX = worker.f_19854_;
            double currentZ = worker.f_19856_;
            double angle = Math.PI * 2 * progress;
            double xOffset = radius * Math.sin(angle);
            double zOffset = radius * Math.cos(angle);
            double targetX = bx + xOffset;
            double targetZ = bz + zOffset;
            worker.m_6021_(targetX, by, targetZ);
            WalkAnimationState animation = worker.f_267362_;
            animation.m_267566_(-animation.m_267756_(), 1.0f);
            float movementYaw = this.calculateYaw(currentX, currentZ, targetX, targetZ);
            worker.m_146922_(movementYaw);
            worker.m_5616_(movementYaw);
        }
    }

    private float calculateYaw(double currentX, double currentZ, double targetX, double targetZ) {
        double deltaX = targetX - currentX;
        double deltaZ = targetZ - currentZ;
        float yaw = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX));
        return yaw -= 90.0f;
    }

    private void adjustRPMModifier(Set<Block> blockSet) {
        this.hasValidWorkingBlocks = true;
        int normalBlocks = 0;
        int greatBlocks = 0;
        for (Block block : blockSet) {
            if (Config.poor_path.contains(block)) {
                this.rpmModifier = 0.5f;
                return;
            }
            if (Config.normal_path.contains(block)) {
                ++normalBlocks;
                continue;
            }
            if (!Config.great_path.contains(block)) continue;
            ++greatBlocks;
        }
        if (normalBlocks > 0) {
            this.rpmModifier = 1.0f;
        } else if (greatBlocks == blockSet.size()) {
            this.rpmModifier = 2.0f;
        }
    }

    private double getTickSpeedModifier() {
        return this.rpmModifier > 0.0f ? 3.001592653589793 / (double)(2.0f * this.rpmModifier) : 0.0;
    }

    private Set<Block> surroundingValidBlocksSet(Block[] surroundingBlocks) {
        return new HashSet<Block>(Arrays.asList(surroundingBlocks));
    }

    private Block[] getValidSurroundingPathBlocks() {
        if (this.cachedSurroundingBlocks != null && this.lastBlockUpdateTick > this.f_58857_.m_46467_() - 40L) {
            return this.cachedSurroundingBlocks;
        }
        HashSet<Block> validBlocks = new HashSet<Block>();
        validBlocks.addAll(Config.poor_path);
        validBlocks.addAll(Config.normal_path);
        validBlocks.addAll(Config.great_path);
        Block[] blockTypeGrid = new Block[OFFSETS.length];
        BlockPos pos = this.m_58899_();
        for (int i = 0; i < OFFSETS.length; ++i) {
            BlockPos targetPos = pos.m_121955_((Vec3i)OFFSETS[i]);
            BlockState targetedBlock = this.f_58857_.m_8055_(targetPos);
            if (!validBlocks.contains(targetedBlock.m_60734_())) continue;
            blockTypeGrid[i] = targetedBlock.m_60734_();
        }
        this.cachedSurroundingBlocks = blockTypeGrid;
        this.lastBlockUpdateTick = this.f_58857_.m_46467_();
        return blockTypeGrid;
    }

    private void updateAnimation() {
        float currentGeneratedSpeed = this.getGeneratedSpeed();
        float currentSpeed = this.getSpeed();
        if (currentGeneratedSpeed == this.lastGeneratedSpeed && currentSpeed == this.lastSpeed) {
            return;
        }
        if (currentGeneratedSpeed == 0.0f && this.lastCapacityProvided != 0.0f) {
            this.updateGeneratedRotation();
        }
        if (currentGeneratedSpeed < 0.0f || currentSpeed < 0.0f) {
            this.setSpeed(-1.0f * currentSpeed);
        }
        this.updateGeneratedRotation();
        this.lastGeneratedSpeed = currentGeneratedSpeed;
        this.lastSpeed = currentSpeed;
    }
}

