/*
 * Decompiled with CFR 0.152.
 */
package net.steampn.createhorsepower.blocks.horse_crank;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.steampn.createhorsepower.blocks.horse_crank.HorseCrankTileEntity;
import net.steampn.createhorsepower.config.Config;
import net.steampn.createhorsepower.registry.TileEntityRegister;
import net.steampn.createhorsepower.utils.CHPShapes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HorseCrankBlock
extends KineticBlock
implements ICogWheel,
IBE<HorseCrankTileEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty HAS_WORKER = BooleanProperty.m_61465_((String)"has_worker");
    public static final BooleanProperty SMALL_WORKER_STATE = BooleanProperty.m_61465_((String)"small_worker");
    public static final BooleanProperty MEDIUM_WORKER_STATE = BooleanProperty.m_61465_((String)"medium_worker");
    public static final BooleanProperty LARGE_WORKER_STATE = BooleanProperty.m_61465_((String)"large_worker");

    public HorseCrankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HAS_WORKER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SMALL_WORKER_STATE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MEDIUM_WORKER_STATE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LARGE_WORKER_STATE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HAS_WORKER, SMALL_WORKER_STATE, MEDIUM_WORKER_STATE, LARGE_WORKER_STATE}));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CHPShapes.HORSE_CRANK;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return super.m_5573_(context);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_() && pState.m_60734_() != pNewState.m_60734_()) {
            pLevel.m_46747_(pPos);
        }
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public Class<HorseCrankTileEntity> getBlockEntityClass() {
        return HorseCrankTileEntity.class;
    }

    public BlockEntityType<? extends HorseCrankTileEntity> getBlockEntityType() {
        return (BlockEntityType)TileEntityRegister.HORSE_CRANK.get();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return TileEntityRegister.HORSE_CRANK.create(pos, state);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() != Items.f_42655_ && !itemStack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_41619_()) {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)HAS_WORKER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SMALL_WORKER_STATE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MEDIUM_WORKER_STATE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LARGE_WORKER_STATE, (Comparable)Boolean.valueOf(false)), 3);
            return this.killLeashEntity(level, pos);
        }
        if (itemStack.m_41720_() == Items.f_42655_) {
            long leashKnots = level.m_45976_(LeashFenceKnotEntity.class, new AABB(pos).m_82400_(0.2)).size();
            if (leashKnots > 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.createhorsepower.horse_crank.alreadyHasWorker"), true);
                return InteractionResult.PASS;
            }
            List mobsNearPlayer = level.m_45976_(Mob.class, new AABB(pos).m_82400_(7.0));
            if (mobsNearPlayer.stream().filter(mob -> mob.m_21523_() && mob.m_21524_() == player).count() <= 0L) {
                return InteractionResult.FAIL;
            }
            if (mobsNearPlayer.stream().filter(mob -> mob.m_21523_() && mob.m_21524_() == player).count() > 1L) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.createhorsepower.horse_crank.maximumMobs"), true);
                return InteractionResult.FAIL;
            }
            if (!this.verifyMobIsInConfig(this.getMobType(this.getMob(mobsNearPlayer, player)), level, pos, state)) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.createhorsepower.horse_crank.notValidWorker"), true);
                return InteractionResult.FAIL;
            }
            LeadItem.m_42829_((Player)player, (Level)level, (BlockPos)pos);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.createhorsepower.horse_crank.attached"), true);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult killLeashEntity(Level level, BlockPos pos) {
        level.m_45976_(LeashFenceKnotEntity.class, new AABB(pos).m_82400_(0.2)).forEach(Entity::m_6074_);
        return InteractionResult.SUCCESS;
    }

    private Mob getMob(List<Mob> mobsNearPlayer, Player player) {
        Stream<Mob> mobsAttachedToPlayer = mobsNearPlayer.stream().filter(mob -> mob.m_21523_() && mob.m_21524_() == player);
        return mobsAttachedToPlayer.toList().get(0);
    }

    private ResourceLocation getMobType(Mob mob) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
    }

    private boolean verifyMobIsInConfig(ResourceLocation mobType, Level level, BlockPos pos, BlockState state) {
        boolean valid = false;
        boolean small = false;
        boolean medium = false;
        boolean large = false;
        if (Config.small_mobs.contains(mobType)) {
            small = true;
            valid = true;
        } else if (Config.medium_mobs.contains(mobType)) {
            medium = true;
            valid = true;
        } else if (Config.large_mobs.contains(mobType)) {
            large = true;
            valid = true;
        }
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)HAS_WORKER, (Comparable)Boolean.valueOf(valid))).m_61124_((Property)SMALL_WORKER_STATE, (Comparable)Boolean.valueOf(small))).m_61124_((Property)MEDIUM_WORKER_STATE, (Comparable)Boolean.valueOf(medium))).m_61124_((Property)LARGE_WORKER_STATE, (Comparable)Boolean.valueOf(large)), 3);
        return small || medium || large;
    }
}

