/*
 * Decompiled with CFR 0.152.
 */
package net.steampn.createhorsepower;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.steampn.createhorsepower.client.ponders.HorseCrankPonderPlugin;
import net.steampn.createhorsepower.config.Config;
import net.steampn.createhorsepower.registry.BlockRegister;
import net.steampn.createhorsepower.registry.TileEntityRegister;
import net.steampn.createhorsepower.utils.CHPBlockPartials;
import org.slf4j.Logger;

@Mod(value="createhorsepower")
public class CreateHorsePower {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "createhorsepower";
    public static final CreateRegistrate CREATE_REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createhorsepower").defaultCreativeTab((ResourceKey)null);

    public CreateHorsePower() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CREATE_REGISTRATE.registerEventListeners(modEventBus);
        BlockRegister.register();
        TileEntityRegister.register();
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.debug("{} is registered!", BlockRegister.HORSE_CRANK.get());
    }

    @SubscribeEvent
    public void serverSetup(ServerStartingEvent event) {
        this.configFileDebug();
    }

    private void configFileDebug() {
        LOGGER.info("Base RPM for all creatures is {}", (Object)Config.base_creature_rpm);
        LOGGER.info("Stress for Small is {}", (Object)Config.small_creature_stress);
        LOGGER.info("Stress for Medium is {}", (Object)Config.medium_creature_stress);
        LOGGER.info("Stress for Large is {}", (Object)Config.large_creature_stress);
        Config.small_mobs.forEach(mob -> LOGGER.info("Selected Small mob: {}", mob));
        Config.medium_mobs.forEach(mob -> LOGGER.info("Selected Medium mob: {}", mob));
        Config.large_mobs.forEach(mob -> LOGGER.info("Selected Large mob: {}", mob));
        Config.poor_path.forEach(block -> LOGGER.info("Selected Poor Path Block: {}", block));
        Config.normal_path.forEach(block -> LOGGER.info("Selected Normal Path Block: {}", block));
        Config.great_path.forEach(block -> LOGGER.info("Selected Great Path Block: {}", block));
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @Mod.EventBusSubscriber(modid="createhorsepower", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            CHPBlockPartials.load();
            PonderIndex.addPlugin((PonderPlugin)new HorseCrankPonderPlugin());
        }
    }
}

