/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.inventory.LimitedContainerData;
import tfar.dankstorage.item.CDankItem;
import tfar.dankstorage.menu.AbstractDankMenu;
import tfar.dankstorage.menu.ChangeFrequencyMenu;
import tfar.dankstorage.mixin.MinecraftServerAccess;
import tfar.dankstorage.network.client.S2CSyncSelectedDankItemPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemStackWrapper;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.TxtColor;
import tfar.dankstorage.utils.UseType;
import tfar.dankstorage.world.ClientData;

public class CommonUtils {
    public static final int INVALID = -1;
    public static final String SET = "settings";
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    public static final String SELECTED = "selectedSlot";
    public static final String CON = "construction";
    public static final String MODE = "mode";
    public static final String FREQ = "dankstorage:frequency";
    private static List<CraftingRecipe> REVERSIBLE3x3 = new ArrayList<CraftingRecipe>();
    private static List<CraftingRecipe> REVERSIBLE2x2 = new ArrayList<CraftingRecipe>();
    private static boolean cached = false;
    private static final CraftingContainer DUMMY = new DummyCraftingContainer(1, 1);

    public static String formatLargeNumber(int number) {
        if (number >= 1000000000) {
            return decimalFormat.format((float)number / 1.0E9f) + "b";
        }
        if (number >= 1000000) {
            return decimalFormat.format((float)number / 1000000.0f) + "m";
        }
        if (number >= 1000) {
            return decimalFormat.format((float)number / 1000.0f) + "k";
        }
        return Float.toString(number).replaceAll("\\.?0*$", "");
    }

    public static DankStats getStatsfromRows(int rows) {
        switch (rows) {
            case 1: {
                return DankStats.one;
            }
            case 2: {
                return DankStats.two;
            }
            case 3: {
                return DankStats.three;
            }
            case 4: {
                return DankStats.four;
            }
            case 5: {
                return DankStats.five;
            }
            case 6: {
                return DankStats.six;
            }
            case 9: {
                return DankStats.seven;
            }
        }
        throw new IllegalStateException(String.valueOf(rows));
    }

    public static void uncacheRecipes() {
        cached = false;
    }

    public static Pair<ItemStack, Integer> compress(ItemStack stack, RegistryAccess registryAccess) {
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return Pair.of((Object)recipe.m_8043_(registryAccess), (Object)9);
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return Pair.of((Object)recipe.m_8043_(registryAccess), (Object)4);
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)0);
    }

    public static boolean canCompress(ServerLevel level, ItemStack stack) {
        if (!cached) {
            REVERSIBLE3x3 = CommonUtils.findReversibles(level, 3);
            REVERSIBLE2x2 = CommonUtils.findReversibles(level, 2);
            cached = true;
        }
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return stack.m_41613_() >= 9;
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return stack.m_41613_() >= 4;
        }
        return false;
    }

    public static void setPickSlot(Level level, ItemStack bag, ItemStack stack) {
        int slot;
        DankInterface dankInterface = CommonUtils.getBagInventory(bag, level);
        if (dankInterface != null && (slot = CommonUtils.findSlotMatchingItem(dankInterface, stack)) != -1) {
            CommonUtils.setSelectedSlot(bag, slot);
        }
    }

    public static int findSlotMatchingItem(DankInterface dankInventory, ItemStack itemStack) {
        for (int i = 0; i < dankInventory.getContainerSizeDank(); ++i) {
            ItemStack stack = dankInventory.getItemDank(i);
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static void changeSelectedSlot(ItemStack bag, boolean right, ServerPlayer player) {
        DankInterface handler = CommonUtils.getBagInventory(bag, (Level)player.m_284548_());
        if (handler == null || handler.noValidSlots()) {
            return;
        }
        int selectedSlot = CommonUtils.getSelectedSlot(bag);
        int size = handler.getContainerSizeDank();
        if (right) {
            if (++selectedSlot >= size) {
                selectedSlot = 0;
            }
        } else if (--selectedSlot < 0) {
            selectedSlot = size - 1;
        }
        ItemStack selected = handler.getItemDank(selectedSlot);
        while (selected.m_41619_() || selected.m_204117_(ModTags.BLACKLISTED_USAGE)) {
            if (right) {
                if (++selectedSlot >= size) {
                    selectedSlot = 0;
                }
            } else if (--selectedSlot < 0) {
                selectedSlot = size - 1;
            }
            selected = handler.getItemDank(selectedSlot);
        }
        if (selectedSlot != -1) {
            CommonUtils.setSelectedSlot(bag, selectedSlot);
            Services.PLATFORM.sendToClient(new S2CSyncSelectedDankItemPacket(selected), player);
            player.m_5661_(selected.m_41786_(), true);
        }
    }

    public static List<CraftingRecipe> findReversibles(ServerLevel level, int size) {
        ArrayList<CraftingRecipe> compactingRecipes = new ArrayList<CraftingRecipe>();
        List recipes = level.m_7465_().m_44013_(RecipeType.f_44107_);
        for (CraftingRecipe recipe : recipes) {
            NonNullList inputs;
            Ingredient first;
            if (!(recipe instanceof ShapedRecipe)) continue;
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            int x = shapedRecipe.m_44220_();
            int y = shapedRecipe.m_44221_();
            if (x != size || x != y || (first = (Ingredient)(inputs = shapedRecipe.m_7527_()).get(0)) == Ingredient.f_43901_) continue;
            boolean same = true;
            for (int i = 1; i < x * y; ++i) {
                Ingredient next = (Ingredient)inputs.get(i);
                if (next == first) continue;
                same = false;
                break;
            }
            if (!same || shapedRecipe.m_8043_(level.m_9598_()).m_41613_() != 1) continue;
            DUMMY.m_6836_(0, shapedRecipe.m_8043_(level.m_9598_()));
            level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)DUMMY, (Level)level).ifPresent(reverseRecipe -> {
                if (reverseRecipe.m_8043_(level.m_9598_()).m_41613_() == size * size) {
                    compactingRecipes.add((CraftingRecipe)shapedRecipe);
                }
            });
        }
        return compactingRecipes;
    }

    public static DankInterface getBagInventory(ItemStack bag, Level level) {
        if (!level.f_46443_) {
            int id = CommonUtils.getFrequency(bag);
            if (id != -1) {
                Path path = ((MinecraftServerAccess)level.m_7654_()).getStorageSource().m_197394_(level.m_7654_().m_129880_(Level.f_46428_).m_46472_()).resolve("data/dankstorage/" + id + ".dat");
                if (path.toFile().isFile()) {
                    return DankStorage.getData(id, level.m_7654_()).createInventory(id);
                }
                return DankStorage.getData(id, level.m_7654_()).createFreshInventory(CommonUtils.getDefaultStats(bag), id);
            }
            return null;
        }
        throw new RuntimeException("Attempted to get inventory on client");
    }

    public static ItemStack getItemStackInSelectedSlot(ItemStack bag, ServerLevel level) {
        DankInterface inv = CommonUtils.getBagInventory(bag, (Level)level);
        if (inv == null) {
            return ItemStack.f_41583_;
        }
        int slot = CommonUtils.getSelectedSlot(bag);
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = inv.getItemDank(slot);
        return stack.m_204117_(ModTags.BLACKLISTED_USAGE) ? ItemStack.f_41583_ : stack;
    }

    public static void merge(List<ItemStack> stacks, ItemStack toMerge) {
        for (ItemStack stack : stacks) {
            int grow;
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)toMerge) || (grow = Math.min(Integer.MAX_VALUE - stack.m_41613_(), toMerge.m_41613_())) <= 0) continue;
            stack.m_41769_(grow);
            toMerge.m_41774_(grow);
        }
        if (!toMerge.m_41619_()) {
            stacks.add(toMerge);
        }
    }

    public static CompoundTag getSettings(ItemStack bag) {
        return CommonUtils.hasSettings(bag) ? bag.m_41783_().m_128469_(SET) : null;
    }

    public static CompoundTag getOrCreateSettings(ItemStack bag) {
        if (CommonUtils.hasSettings(bag)) {
            return bag.m_41783_().m_128469_(SET);
        }
        bag.m_41784_().m_128365_(SET, (Tag)new CompoundTag());
        return CommonUtils.getSettings(bag);
    }

    private static boolean hasSettings(ItemStack bag) {
        return bag.m_41782_() && bag.m_41783_().m_128441_(SET);
    }

    public static PickupMode getPickupMode(ItemStack bag) {
        CompoundTag tag = CommonUtils.getSettings(bag);
        if (tag != null) {
            return PickupMode.VALUES[tag.m_128451_(MODE)];
        }
        return PickupMode.none;
    }

    public static void setPickupMode(ItemStack bag, PickupMode mode) {
        CompoundTag tag = CommonUtils.getOrCreateSettings(bag);
        tag.m_128405_(MODE, mode.ordinal());
    }

    public static boolean isConstruction(ItemStack bag) {
        CompoundTag settings = CommonUtils.getSettings(bag);
        return settings != null && settings.m_128451_(CON) == UseType.construction.ordinal();
    }

    public static void cyclePickupMode(ItemStack bag, Player player) {
        int ordinal = CommonUtils.getOrCreateSettings(bag).m_128451_(MODE);
        if (++ordinal > PickupMode.VALUES.length - 1) {
            ordinal = 0;
        }
        CommonUtils.getOrCreateSettings(bag).m_128405_(MODE, ordinal);
        player.m_5661_((Component)CommonUtils.translatable("dankstorage.mode." + PickupMode.VALUES[ordinal].name()), true);
    }

    public static UseType getUseType(ItemStack bag) {
        CompoundTag settings = CommonUtils.getSettings(bag);
        return settings != null ? UseType.useTypes[settings.m_128451_(CON)] : UseType.bag;
    }

    public static void cyclePlacement(ItemStack bag, Player player) {
        CompoundTag tag = CommonUtils.getOrCreateSettings(bag);
        int ordinal = tag.m_128451_(CON);
        if (++ordinal >= UseType.useTypes.length) {
            ordinal = 0;
        }
        tag.m_128405_(CON, ordinal);
        player.m_5661_((Component)CommonUtils.translatable("dankstorage.usetype." + UseType.useTypes[ordinal].name()), true);
    }

    public static int getSelectedSlot(ItemStack bag) {
        CompoundTag settings = CommonUtils.getSettings(bag);
        return settings != null && settings.m_128441_(SELECTED) ? settings.m_128451_(SELECTED) : -1;
    }

    public static void setSelectedSlot(ItemStack bag, int slot) {
        CommonUtils.getOrCreateSettings(bag).m_128405_(SELECTED, slot);
    }

    public static int getFrequency(ItemStack bag) {
        CompoundTag settings = CommonUtils.getSettings(bag);
        if (settings != null && settings.m_128441_(FREQ)) {
            return settings.m_128451_(FREQ);
        }
        return -1;
    }

    public static void setFrequency(ItemStack bag, int frequency) {
        CommonUtils.getOrCreateSettings(bag).m_128405_(FREQ, frequency);
    }

    public static MutableComponent translatable(String s) {
        return Component.m_237115_((String)s);
    }

    public static MutableComponent translatable(String string, Object ... objects) {
        return Component.m_237110_((String)string, (Object[])objects);
    }

    public static MutableComponent literal(String s) {
        return Component.m_237113_((String)s);
    }

    public static boolean oredict(ItemStack bag) {
        return bag.m_41782_() && CommonUtils.getSettings(bag).m_128471_("tag");
    }

    public static void warn(Player player, DankStats item, DankStats inventory) {
        player.m_213846_((Component)CommonUtils.literal("Dank Item Level " + item.ordinal() + " cannot open Dank Inventory Level " + inventory.ordinal()));
    }

    public static int getNbtSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130079_(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static List<ItemStackWrapper> wrap(List<ItemStack> stacks) {
        return stacks.stream().map(ItemStackWrapper::new).collect(Collectors.toList());
    }

    public static CDankItem getItemFromTier(int tier) {
        return (CDankItem)((Object)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("dankstorage", "dank_" + tier)));
    }

    public static boolean isHoldingDank(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof CDankItem) {
            return true;
        }
        stack = player.m_21206_();
        return stack.m_41720_() instanceof CDankItem;
    }

    public static ItemStack getSelectedItem(ItemStack bag, Level level) {
        if (bag.m_41782_()) {
            int selected = CommonUtils.getSelectedSlot(bag);
            if (selected == -1) {
                return ItemStack.f_41583_;
            }
            if (!level.f_46443_) {
                DankInterface dankInventory = CommonUtils.getBagInventory(bag, level);
                if (dankInventory != null) {
                    return dankInventory.getItemDank(selected);
                }
            } else {
                return ClientData.selectedItem;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static InteractionHand getHandWithDank(Player player) {
        if (player.m_21205_().m_41720_() instanceof CDankItem) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.m_21206_().m_41720_() instanceof CDankItem) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static ItemStack getDank(Player player) {
        InteractionHand hand = CommonUtils.getHandWithDank(player);
        return hand == null ? ItemStack.f_41583_ : player.m_21120_(hand);
    }

    public static void toggleTagMode(ServerPlayer player) {
        ItemStack dank = CommonUtils.getDank((Player)player);
        if (!dank.m_41619_()) {
            boolean toggle = CommonUtils.oredict(dank);
            player.m_21205_().m_41784_().m_128379_("tag", !toggle);
        }
    }

    public static void togglePickupMode(ServerPlayer player) {
        ItemStack bag = CommonUtils.getDank((Player)player);
        if (!bag.m_41619_()) {
            CommonUtils.cyclePickupMode(bag, (Player)player);
        }
    }

    public static void toggleUseType(ServerPlayer player) {
        ItemStack dank = CommonUtils.getDank((Player)player);
        if (!dank.m_41619_()) {
            CommonUtils.cyclePlacement(dank, (Player)player);
        }
    }

    public static void setTxtColor(ServerPlayer player, int frequency, boolean set) {
        AbstractContainerMenu container = player.f_36096_;
        if (container instanceof AbstractDankMenu) {
            TxtColor textColor;
            AbstractDankMenu abstractDankMenu = (AbstractDankMenu)container;
            DankInterface inventory = abstractDankMenu.dankInventory;
            if (frequency > -1) {
                if (frequency < DankStorage.maxId.getMaxId()) {
                    DankInterface targetInventory = DankStorage.getData(frequency, player.f_8924_).createInventory(frequency);
                    if (targetInventory.valid() && targetInventory.getDankStats() == inventory.getDankStats()) {
                        if (targetInventory.frequencyLocked()) {
                            textColor = TxtColor.LOCKED;
                        } else {
                            textColor = TxtColor.GOOD;
                            if (set) {
                                abstractDankMenu.setFrequency(frequency);
                                player.m_6915_();
                            }
                        }
                    } else {
                        textColor = TxtColor.DIFFERENT_TIER;
                    }
                } else {
                    textColor = TxtColor.TOO_HIGH;
                }
            } else {
                textColor = TxtColor.INVALID;
            }
            inventory.setTextColor(textColor.color);
        } else if (container instanceof ChangeFrequencyMenu) {
            TxtColor textColor;
            ChangeFrequencyMenu changeFrequencyMenu = (ChangeFrequencyMenu)container;
            DankInterface inventory = (DankInterface)((LimitedContainerData)changeFrequencyMenu.getContainerData()).getWrapped();
            if (frequency > -1) {
                if (frequency < DankStorage.maxId.getMaxId()) {
                    DankInterface targetInventory = DankStorage.getData(frequency, player.f_8924_).createInventory(frequency);
                    if (targetInventory.valid() && targetInventory.getDankStats() == DankStats.values()[changeFrequencyMenu.getCurrentTier()]) {
                        if (targetInventory.frequencyLocked()) {
                            textColor = TxtColor.LOCKED;
                        } else {
                            textColor = TxtColor.GOOD;
                            if (set) {
                                changeFrequencyMenu.setLinkedFrequency(frequency);
                                player.m_6915_();
                            }
                        }
                    } else {
                        textColor = TxtColor.DIFFERENT_TIER;
                    }
                } else {
                    textColor = TxtColor.TOO_HIGH;
                }
            } else {
                textColor = TxtColor.INVALID;
            }
            inventory.setTextColor(textColor.color);
        }
    }

    public static DankStats getDefaultStats(ItemStack bag) {
        return ((CDankItem)bag.m_41720_()).stats;
    }

    @Nonnull
    public static ItemStack copyStackWithSize(@Nonnull ItemStack itemStack, int size) {
        if (size == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    public static class DummyCraftingContainer
    implements CraftingContainer {
        private final NonNullList<ItemStack> items;
        private final int width;
        private final int height;

        public DummyCraftingContainer(int p_287629_, int p_287593_) {
            this(p_287629_, p_287593_, (NonNullList<ItemStack>)NonNullList.m_122780_((int)(p_287629_ * p_287593_), (Object)ItemStack.f_41583_));
        }

        public DummyCraftingContainer(int p_287591_, int p_287609_, NonNullList<ItemStack> p_287695_) {
            this.items = p_287695_;
            this.width = p_287591_;
            this.height = p_287609_;
        }

        public int m_6643_() {
            return this.items.size();
        }

        public boolean m_7983_() {
            for (ItemStack itemstack : this.items) {
                if (itemstack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return slot >= this.m_6643_() ? ItemStack.f_41583_ : (ItemStack)this.items.get(slot);
        }

        public ItemStack m_8016_(int slot) {
            return ContainerHelper.m_18966_(this.items, (int)slot);
        }

        public ItemStack m_7407_(int i, int i1) {
            return ContainerHelper.m_18969_(this.items, (int)i, (int)i1);
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.items.set(slot, (Object)stack);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            this.items.clear();
        }

        public int m_39346_() {
            return this.height;
        }

        public int m_39347_() {
            return this.width;
        }

        public List<ItemStack> m_280657_() {
            return List.copyOf(this.items);
        }

        public void m_5809_(StackedContents contents) {
            for (ItemStack itemstack : this.items) {
                contents.m_36466_(itemstack);
            }
        }
    }
}

