/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.world.DankInventoryForge;

public class DankItemCapability
implements ICapabilityProvider {
    private final ItemStack container;

    public DankItemCapability(ItemStack container) {
        this.container = container;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(this::lookup));
    }

    protected DankInventoryForge lookup() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return (DankInventoryForge)CommonUtils.getBagInventory(this.container, (Level)server.m_129880_(Level.f_46428_));
        }
        return new DankInventoryForge(DankStats.zero, -1);
    }
}

