/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.item.CDankItem;
import tfar.dankstorage.utils.CommonUtils;

public class DankCommands {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dankstorage").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(commandSourceStack -> commandSourceStack.m_6761_(3))).then(Commands.m_82127_((String)"all").executes(DankCommands::clearAll))).then(Commands.m_82129_((String)"dankstorage:frequency", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(DankCommands::clearID)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_tier").requires(commandSourceStack -> commandSourceStack.m_6761_(3))).then(Commands.m_82129_((String)"dankstorage:frequency", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).executes(DankCommands::setTier))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lock").requires(commandSourceStack -> commandSourceStack.m_6761_(3))).then(Commands.m_82129_((String)"dankstorage:frequency", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(DankCommands::lock)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlock").requires(commandSourceStack -> commandSourceStack.m_6761_(3))).then(Commands.m_82129_((String)"dankstorage:frequency", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(DankCommands::unlock)))).then(Commands.m_82127_((String)"reset_frequency").executes(DankCommands::resetFrequency)));
    }

    private static int clearAll(CommandContext<CommandSourceStack> context) {
        return 1;
    }

    private static int clearID(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"dankstorage:frequency");
        boolean success = DankStorage.getData(id, ((CommandSourceStack)context.getSource()).m_81377_()).clear();
        if (!success) {
            throw new CommandRuntimeException((Component)CommonUtils.translatable("dankstorage.command.clear_id.invalid_id"));
        }
        return 1;
    }

    private static int setTier(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"dankstorage:frequency");
        int tier = IntegerArgumentType.getInteger(context, (String)"tier");
        boolean success = false;
        if (!success) {
            throw new CommandRuntimeException((Component)CommonUtils.translatable("dankstorage.command.set_tier.invalid_id"));
        }
        return 1;
    }

    private static int resetFrequency(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)context.getSource();
        ServerPlayer player = sourceStack.m_81375_();
        ItemStack dank = player.m_21205_();
        if (dank.m_41720_() instanceof CDankItem) {
            dank.m_41751_(null);
            return 1;
        }
        throw new CommandRuntimeException((Component)CommonUtils.translatable("dankstorage.command.reset_frequency.not_a_dank"));
    }

    private static int lock(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"dankstorage:frequency");
        boolean success = false;
        if (!success) {
            throw new CommandRuntimeException((Component)CommonUtils.translatable("dankstorage.command.lock.invalid_id"));
        }
        return 1;
    }

    private static int unlock(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"dankstorage:frequency");
        boolean success = false;
        if (!success) {
            throw new CommandRuntimeException((Component)CommonUtils.translatable("dankstorage.command.unlock.invalid_id"));
        }
        return 1;
    }
}

