/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage;

import java.io.File;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.dankstorage.init.ModBlockEntityTypes;
import tfar.dankstorage.init.ModBlocks;
import tfar.dankstorage.init.ModCreativeTabs;
import tfar.dankstorage.init.ModItems;
import tfar.dankstorage.init.ModMenuTypes;
import tfar.dankstorage.init.ModRecipeSerializers;
import tfar.dankstorage.mixin.MinecraftServerAccess;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.world.CDankSavedData;
import tfar.dankstorage.world.MaxId;

public class DankStorage {
    public static final String MODID = "dankstorage";
    public static final String MOD_NAME = "Dank-Storage";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dank-Storage");
    public static MaxId maxId;

    public static void init() {
        Services.PLATFORM.registerAll(ModBlocks.class, BuiltInRegistries.f_256975_, Block.class);
        Class<BlockEntityType> typeClass = BlockEntityType.class;
        Class<MenuType> typeClass1 = MenuType.class;
        Class<RecipeSerializer> typeClass2 = RecipeSerializer.class;
        Services.PLATFORM.registerAll(ModBlockEntityTypes.class, BuiltInRegistries.f_257049_, typeClass);
        Services.PLATFORM.unfreeze(BuiltInRegistries.f_257033_);
        Services.PLATFORM.registerAll(ModItems.getAll(), BuiltInRegistries.f_257033_, Item.class);
        Services.PLATFORM.registerAll(ModCreativeTabs.class, BuiltInRegistries.f_279662_, CreativeModeTab.class);
        Services.PLATFORM.registerAll(ModMenuTypes.class, BuiltInRegistries.f_256818_, typeClass1);
        Services.PLATFORM.registerAll(ModRecipeSerializers.class, BuiltInRegistries.f_256769_, typeClass2);
        DankPacketHandler.registerPackets();
    }

    public static MaxId getMaxId(MinecraftServer server) {
        return (MaxId)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(MaxId::loadStatic, MaxId::new, "dankstorage:max_id");
    }

    public static void onServerShutDown(MinecraftServer server) {
        maxId = null;
        CommonUtils.uncacheRecipes();
    }

    public static void onServerStart(MinecraftServer server) {
        LevelStorageSource.LevelStorageAccess storageSource = ((MinecraftServerAccess)server).getStorageSource();
        File file = storageSource.m_197394_(server.m_129880_(Level.f_46428_).m_46472_()).resolve("data/dankstorage").toFile();
        file.mkdirs();
        maxId = DankStorage.getMaxId(server);
    }

    public static CDankSavedData getData(int id, MinecraftServer server) {
        if (id <= -1) {
            throw new RuntimeException("Invalid frequency: " + id);
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        return (CDankSavedData)overworld.m_8895_().m_164861_(compoundTag -> CDankSavedData.loadStatic(compoundTag, overworld), () -> new CDankSavedData(overworld), "dankstorage/" + id);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }
}

