/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DropdownBoxEntry<T>
extends TooltipListEntry<T> {
    protected Button resetButton;
    protected SelectionElement<T> selectionElement;
    @NotNull
    private final Supplier<T> defaultValue;
    private boolean suggestionMode = true;

    @Deprecated
    @ApiStatus.Internal
    public DropdownBoxEntry(Component fieldName, @NotNull Component resetButtonKey, @Nullable Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart, @Nullable Supplier<T> defaultValue, @Nullable Consumer<T> saveConsumer, @Nullable Iterable<T> selections, @NotNull SelectionTopCellElement<T> topRenderer, @NotNull SelectionCellCreator<T> cellCreator) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.saveCallback = saveConsumer;
        this.resetButton = Button.m_253074_((Component)resetButtonKey, widget -> this.selectionElement.topRenderer.setValue(defaultValue.get())).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20).m_253136_();
        this.selectionElement = new SelectionElement(this, new Rectangle(0, 0, 150, 20), new DefaultDropdownMenuElement(selections == null ? ImmutableList.of() : ImmutableList.copyOf(selections)), topRenderer, cellCreator);
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && (!this.defaultValue.get().equals(this.getValue()) || this.getConfigError().isPresent());
        this.resetButton.m_253211_(y);
        this.selectionElement.active = this.isEditable();
        this.selectionElement.bounds.y = y;
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, displayedFieldName.m_7532_(), window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName), y + 6, this.getPreferredTextColor());
            this.resetButton.m_252865_(x);
            this.selectionElement.bounds.x = x + this.resetButton.m_5711_() + 1;
        } else {
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, displayedFieldName.m_7532_(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.m_252865_(x + entryWidth - this.resetButton.m_5711_());
            this.selectionElement.bounds.x = x + entryWidth - 150 + 1;
        }
        this.selectionElement.bounds.width = 150 - this.resetButton.m_5711_() - 4;
        this.resetButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.selectionElement.m_88315_(graphics, mouseX, mouseY, delta);
    }

    @Override
    public boolean isEdited() {
        return this.selectionElement.topRenderer.isEdited();
    }

    public boolean isSuggestionMode() {
        return this.suggestionMode;
    }

    public void setSuggestionMode(boolean suggestionMode) {
        this.suggestionMode = suggestionMode;
    }

    @Override
    public void updateSelected(boolean isSelected) {
        this.selectionElement.topRenderer.isSelected = isSelected;
        this.selectionElement.menu.isSelected = isSelected;
    }

    @NotNull
    public ImmutableList<T> getSelections() {
        return this.selectionElement.menu.getSelections();
    }

    @Override
    public T getValue() {
        return this.selectionElement.getValue();
    }

    @Deprecated
    public SelectionElement<T> getSelectionElement() {
        return this.selectionElement;
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Lists.newArrayList((Object[])new GuiEventListener[]{this.selectionElement, this.resetButton});
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return Collections.singletonList(this.resetButton);
    }

    @Override
    public Optional<Component> getError() {
        return this.selectionElement.topRenderer.getError();
    }

    @Override
    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.selectionElement.lateRender(graphics, mouseX, mouseY, delta);
    }

    @Override
    public int getMorePossibleHeight() {
        return this.selectionElement.getMorePossibleHeight();
    }

    @Override
    public boolean m_6050_(double double_1, double double_2, double double_3) {
        return this.selectionElement.m_6050_(double_1, double_2, double_3);
    }

    public static class SelectionElement<R>
    extends AbstractContainerEventHandler
    implements Renderable {
        protected Rectangle bounds;
        protected boolean active;
        protected SelectionTopCellElement<R> topRenderer;
        protected DropdownBoxEntry<R> entry;
        protected DropdownMenuElement<R> menu;
        protected boolean dontReFocus = false;

        public SelectionElement(DropdownBoxEntry<R> entry, Rectangle bounds, DropdownMenuElement<R> menu, SelectionTopCellElement<R> topRenderer, SelectionCellCreator<R> cellCreator) {
            this.bounds = bounds;
            this.entry = entry;
            this.menu = Objects.requireNonNull(menu);
            this.menu.entry = entry;
            this.menu.cellCreator = Objects.requireNonNull(cellCreator);
            this.menu.initCells();
            this.topRenderer = Objects.requireNonNull(topRenderer);
            this.topRenderer.entry = entry;
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            graphics.m_280509_(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, this.topRenderer.isSelected ? -1 : -6250336);
            graphics.m_280509_(this.bounds.x + 1, this.bounds.y + 1, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1, -16777216);
            this.topRenderer.render(graphics, mouseX, mouseY, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, delta);
            if (this.menu.isExpanded()) {
                this.menu.render(graphics, mouseX, mouseY, this.bounds, delta);
            }
        }

        @Deprecated
        public SelectionTopCellElement<R> getTopRenderer() {
            return this.topRenderer;
        }

        public boolean m_6050_(double double_1, double double_2, double double_3) {
            if (this.menu.isExpanded()) {
                return this.menu.m_6050_(double_1, double_2, double_3);
            }
            return false;
        }

        public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.menu.isExpanded()) {
                this.menu.lateRender(graphics, mouseX, mouseY, delta);
            }
        }

        public int getMorePossibleHeight() {
            if (this.menu.isExpanded()) {
                return this.menu.getHeight();
            }
            return -1;
        }

        public R getValue() {
            return this.topRenderer.getValue();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Lists.newArrayList((Object[])new AbstractContainerEventHandler[]{this.topRenderer, this.menu});
        }

        public boolean m_6375_(double double_1, double double_2, int int_1) {
            this.dontReFocus = false;
            boolean b = super.m_6375_(double_1, double_2, int_1);
            if (this.dontReFocus) {
                this.m_7522_(null);
                this.dontReFocus = false;
            }
            return b;
        }
    }

    public static class DefaultDropdownMenuElement<R>
    extends DropdownMenuElement<R> {
        @NotNull
        protected ImmutableList<R> selections;
        @NotNull
        protected List<SelectionCellElement<R>> cells;
        @NotNull
        protected List<SelectionCellElement<R>> currentElements;
        protected Component lastSearchKeyword = Component.m_237119_();
        protected Rectangle lastRectangle;
        protected boolean scrolling;
        protected double scroll;
        protected double target;
        protected long start;
        protected long duration;

        public DefaultDropdownMenuElement(@NotNull ImmutableList<R> selections) {
            this.selections = selections;
            this.cells = Lists.newArrayList();
            this.currentElements = Lists.newArrayList();
        }

        public double getMaxScroll() {
            return this.getCellCreator().getCellHeight() * this.currentElements.size();
        }

        protected double getMaxScrollPosition() {
            return Math.max(0.0, this.getMaxScroll() - (double)this.getHeight());
        }

        @Override
        @NotNull
        public ImmutableList<R> getSelections() {
            return this.selections;
        }

        @Override
        public void initCells() {
            for (Object selection : this.getSelections()) {
                this.cells.add(this.getCellCreator().create(selection));
            }
            for (SelectionCellElement cell : this.cells) {
                cell.entry = this.getEntry();
            }
            this.search();
        }

        public void search() {
            if (this.isSuggestionMode()) {
                this.currentElements.clear();
                String keyword = this.lastSearchKeyword.getString().toLowerCase();
                for (SelectionCellElement<R> cell : this.cells) {
                    Component key = cell.getSearchKey();
                    if (key != null && !key.getString().toLowerCase().contains(keyword)) continue;
                    this.currentElements.add(cell);
                }
                if (!keyword.isEmpty()) {
                    Comparator<SelectionCellElement> c = Comparator.comparingDouble(i -> i.getSearchKey() == null ? Double.MAX_VALUE : this.similarity(i.getSearchKey().getString(), keyword));
                    this.currentElements.sort(c.reversed());
                }
                this.scrollTo(0.0, false);
            } else {
                this.currentElements.clear();
                this.currentElements.addAll(this.cells);
            }
        }

        protected int editDistance(String s1, String s2) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            int[] costs = new int[s2.length() + 1];
            for (int i = 0; i <= s1.length(); ++i) {
                int lastValue = i;
                for (int j = 0; j <= s2.length(); ++j) {
                    if (i == 0) {
                        costs[j] = j;
                        continue;
                    }
                    if (j <= 0) continue;
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                if (i <= 0) continue;
                costs[s2.length()] = lastValue;
            }
            return costs[s2.length()];
        }

        protected double similarity(String s1, String s2) {
            int longerLength;
            String longer = s1;
            String shorter = s2;
            if (s1.length() < s2.length()) {
                longer = s2;
                shorter = s1;
            }
            if ((longerLength = longer.length()) == 0) {
                return 1.0;
            }
            return (double)(longerLength - this.editDistance(longer, shorter)) / (double)longerLength;
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, Rectangle rectangle, float delta) {
            if (!this.getEntry().selectionElement.topRenderer.getSearchTerm().equals(this.lastSearchKeyword)) {
                this.lastSearchKeyword = this.getEntry().selectionElement.topRenderer.getSearchTerm();
                this.search();
            }
            this.updatePosition(delta);
            this.lastRectangle = rectangle.clone();
            this.lastRectangle.translate(0, -1);
        }

        private void updatePosition(float delta) {
            double[] target = new double[]{this.target};
            this.scroll = ScrollingContainer.handleScrollingPosition(target, this.scroll, this.getMaxScrollPosition(), delta, this.start, this.duration);
            this.target = target[0];
        }

        @Override
        public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int last10Height = this.getHeight();
            int cWidth = this.getCellCreator().getCellWidth();
            graphics.m_280509_(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height, this.lastRectangle.x + cWidth, this.lastRectangle.y + this.lastRectangle.height + last10Height + 1, this.isExpanded() ? -1 : -6250336);
            graphics.m_280509_(this.lastRectangle.x + 1, this.lastRectangle.y + this.lastRectangle.height + 1, this.lastRectangle.x + cWidth - 1, this.lastRectangle.y + this.lastRectangle.height + last10Height, -16777216);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            ScissorsHandler.INSTANCE.scissor(new Rectangle(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height + 1, cWidth - 6, last10Height - 1));
            double yy = (double)(this.lastRectangle.y + this.lastRectangle.height) - this.scroll;
            for (SelectionCellElement<R> cell : this.currentElements) {
                if (yy + (double)this.getCellCreator().getCellHeight() >= (double)(this.lastRectangle.y + this.lastRectangle.height) && yy <= (double)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1)) {
                    cell.render(graphics, mouseX, mouseY, this.lastRectangle.x, (int)yy, this.getMaxScrollPosition() > 6.0 ? this.getCellCreator().getCellWidth() - 6 : this.getCellCreator().getCellWidth(), this.getCellCreator().getCellHeight(), delta);
                } else {
                    cell.dontRender(graphics, delta);
                }
                yy += (double)this.getCellCreator().getCellHeight();
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.currentElements.isEmpty()) {
                Font textRenderer = Minecraft.m_91087_().f_91062_;
                MutableComponent text = Component.m_237115_((String)"text.cloth-config.dropdown.value.unknown");
                graphics.m_280648_(textRenderer, text.m_7532_(), (int)((float)this.lastRectangle.x + (float)this.getCellCreator().getCellWidth() / 2.0f - (float)textRenderer.m_92852_((FormattedText)text) / 2.0f), this.lastRectangle.y + this.lastRectangle.height + 3, -1);
            }
            if (this.getMaxScrollPosition() > 6.0) {
                RenderSystem.setShader(GameRenderer::m_172820_);
                int scrollbarPositionMinX = this.lastRectangle.x + this.getCellCreator().getCellWidth() - 6;
                int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
                int height = (int)((double)(last10Height * last10Height) / this.getMaxScrollPosition());
                height = Mth.m_14045_((int)height, (int)32, (int)(last10Height - 8));
                height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > this.getMaxScrollPosition() ? (double)((int)this.scroll) - this.getMaxScrollPosition() : 0.0), (double)height * 0.95));
                height = Math.max(10, height);
                int minY = (int)Math.min(Math.max((double)((int)this.scroll * (last10Height - height)) / this.getMaxScrollPosition() + (double)(this.lastRectangle.y + this.lastRectangle.height + 1), (double)(this.lastRectangle.y + this.lastRectangle.height + 1)), (double)(this.lastRectangle.y + this.lastRectangle.height + 1 + last10Height - height));
                int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
                int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height), 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                buffer.m_5483_((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                buffer.m_5483_((double)scrollbarPositionMaxX, (double)minY, 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                tesselator.m_85914_();
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        public int getHeight() {
            return Math.max(Math.min(this.getCellCreator().getDropBoxMaxHeight(), (int)this.getMaxScroll()), 14);
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.isExpanded() && mouseX >= (double)this.lastRectangle.x && mouseX <= (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth()) && mouseY >= (double)(this.lastRectangle.y + this.lastRectangle.height) && mouseY <= (double)(this.lastRectangle.y + this.lastRectangle.height + this.getHeight() + 1);
        }

        public boolean m_7979_(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!this.isExpanded()) {
                return false;
            }
            if (int_1 == 0 && this.scrolling) {
                if (double_2 < (double)this.lastRectangle.y + (double)this.lastRectangle.height) {
                    this.scrollTo(0.0, false);
                } else if (double_2 > (double)this.lastRectangle.y + (double)this.lastRectangle.height + (double)this.getHeight()) {
                    this.scrollTo(this.getMaxScrollPosition(), false);
                } else {
                    double double_5 = Math.max(1.0, this.getMaxScrollPosition());
                    int int_2 = this.getHeight();
                    int int_3 = Mth.m_14045_((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                    double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                    this.offset(double_4 * double_6, false);
                }
                this.target = Mth.m_14008_((double)this.target, (double)0.0, (double)this.getMaxScrollPosition());
                return true;
            }
            return false;
        }

        public boolean m_6050_(double mouseX, double mouseY, double double_3) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        protected void updateScrollingState(double double_1, double double_2, int int_1) {
            this.scrolling = this.isExpanded() && this.lastRectangle != null && int_1 == 0 && double_1 >= (double)this.lastRectangle.x + (double)this.getCellCreator().getCellWidth() - 6.0 && double_1 < (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth());
        }

        public boolean m_6375_(double double_1, double double_2, int int_1) {
            if (!this.isExpanded()) {
                return false;
            }
            this.updateScrollingState(double_1, double_2, int_1);
            return super.m_6375_(double_1, double_2, int_1) || this.scrolling;
        }

        public void offset(double value, boolean animated) {
            this.scrollTo(this.target + value, animated);
        }

        public void scrollTo(double value, boolean animated) {
            this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }

        public void scrollTo(double value, boolean animated, long duration) {
            this.target = ScrollingContainer.clampExtension(value, this.getMaxScrollPosition());
            if (animated) {
                this.start = System.currentTimeMillis();
                this.duration = duration;
            } else {
                this.scroll = this.target;
            }
        }

        @Override
        public List<SelectionCellElement<R>> m_6702_() {
            return this.currentElements;
        }
    }

    public static abstract class DropdownMenuElement<R>
    extends AbstractContainerEventHandler {
        @Deprecated
        @NotNull
        private SelectionCellCreator<R> cellCreator;
        @Deprecated
        @NotNull
        private DropdownBoxEntry<R> entry;
        private boolean isSelected;

        @NotNull
        public SelectionCellCreator<R> getCellCreator() {
            return this.cellCreator;
        }

        @NotNull
        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        @NotNull
        public abstract ImmutableList<R> getSelections();

        public abstract void initCells();

        public abstract void render(GuiGraphics var1, int var2, int var3, Rectangle var4, float var5);

        public abstract void lateRender(GuiGraphics var1, int var2, int var3, float var4);

        public abstract int getHeight();

        public final boolean isExpanded() {
            return this.isSelected && this.getEntry().m_7222_() == this.getEntry().selectionElement;
        }

        public final boolean isSuggestionMode() {
            return this.entry.isSuggestionMode();
        }

        public abstract List<SelectionCellElement<R>> m_6702_();
    }

    public static abstract class SelectionTopCellElement<R>
    extends AbstractContainerEventHandler {
        @Deprecated
        private DropdownBoxEntry<R> entry;
        protected boolean isSelected = false;

        public abstract R getValue();

        public abstract void setValue(R var1);

        public abstract Component getSearchTerm();

        public boolean isEdited() {
            return this.getConfigError().isPresent();
        }

        public abstract Optional<Component> getError();

        public final Optional<Component> getConfigError() {
            return this.entry.getConfigError();
        }

        public DropdownBoxEntry<R> getParent() {
            return this.entry;
        }

        public final boolean hasConfigError() {
            return this.getConfigError().isPresent();
        }

        public final boolean hasError() {
            return this.getError().isPresent();
        }

        public final int getPreferredTextColor() {
            return this.getConfigError().isPresent() ? 0xFF5555 : 0xFFFFFF;
        }

        public final boolean isSuggestionMode() {
            return this.getParent().isSuggestionMode();
        }

        public void selectFirstRecommendation() {
            List children = this.getParent().selectionElement.menu.m_6702_();
            for (SelectionCellElement child : children) {
                if (child.getSelection() == null) continue;
                this.setValue(child.getSelection());
                this.getParent().selectionElement.m_7522_(null);
                break;
            }
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
    }

    public static abstract class SelectionCellCreator<R> {
        public abstract SelectionCellElement<R> create(R var1);

        public abstract int getCellHeight();

        public abstract int getDropBoxMaxHeight();

        public int getCellWidth() {
            return 132;
        }
    }

    public static class DefaultSelectionTopCellElement<R>
    extends SelectionTopCellElement<R> {
        protected EditBox textFieldWidget;
        protected Function<String, R> toObjectFunction;
        protected Function<R, Component> toTextFunction;
        protected final R original;
        protected R value;

        public DefaultSelectionTopCellElement(R value, Function<String, R> toObjectFunction, Function<R, Component> toTextFunction) {
            this.original = Objects.requireNonNull(value);
            this.value = Objects.requireNonNull(value);
            this.toObjectFunction = Objects.requireNonNull(toObjectFunction);
            this.toTextFunction = Objects.requireNonNull(toTextFunction);
            this.textFieldWidget = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 148, 18, (Component)Component.m_237119_()){

                public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    this.m_93692_(this.isSuggestionMode() && isSelected && this.getParent().m_7222_() == this.getParent().selectionElement && this.getParent().selectionElement.m_7222_() == this && this.m_7222_() == this);
                    super.m_88315_(graphics, mouseX, mouseY, delta);
                }

                public boolean m_7933_(int int_1, int int_2, int int_3) {
                    if (int_1 == 257 || int_1 == 335) {
                        this.selectFirstRecommendation();
                        return true;
                    }
                    return this.isSuggestionMode() && super.m_7933_(int_1, int_2, int_3);
                }

                public boolean m_5534_(char chr, int keyCode) {
                    return this.isSuggestionMode() && super.m_5534_(chr, keyCode);
                }
            };
            this.textFieldWidget.m_94182_(false);
            this.textFieldWidget.m_94199_(999999);
            this.textFieldWidget.m_94144_(toTextFunction.apply(value).getString());
        }

        @Override
        public boolean isEdited() {
            return super.isEdited() || !this.getValue().equals(this.original);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            this.textFieldWidget.m_252865_(x + 4);
            this.textFieldWidget.m_253211_(y + 6);
            this.textFieldWidget.m_93674_(width - 8);
            this.textFieldWidget.m_94186_(this.getParent().isEditable());
            this.textFieldWidget.m_94202_(this.getPreferredTextColor());
            this.textFieldWidget.m_88315_(graphics, mouseX, mouseY, delta);
        }

        @Override
        public R getValue() {
            if (this.hasError()) {
                return this.value;
            }
            return this.toObjectFunction.apply(this.textFieldWidget.m_94155_());
        }

        @Override
        public void setValue(R value) {
            this.textFieldWidget.m_94144_(this.toTextFunction.apply(value).getString());
            this.textFieldWidget.m_94192_(0);
        }

        @Override
        public Component getSearchTerm() {
            return Component.m_237113_((String)this.textFieldWidget.m_94155_());
        }

        @Override
        public Optional<Component> getError() {
            if (this.toObjectFunction.apply(this.textFieldWidget.m_94155_()) != null) {
                return Optional.empty();
            }
            return Optional.of(Component.m_237113_((String)"Invalid Value!"));
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.textFieldWidget);
        }
    }

    public static class DefaultSelectionCellElement<R>
    extends SelectionCellElement<R> {
        protected R r;
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected boolean rendering;
        protected Function<R, Component> toTextFunction;

        public DefaultSelectionCellElement(R r, Function<R, Component> toTextFunction) {
            this.r = r;
            this.toTextFunction = toTextFunction;
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            boolean b;
            this.rendering = true;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
            if (b) {
                graphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, -15132391);
            }
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, this.toTextFunction.apply(this.r).m_7532_(), x + 6, y + 3, b ? 0xFFFFFF : 0x888888);
        }

        @Override
        public void dontRender(GuiGraphics graphics, float delta) {
            this.rendering = false;
        }

        @Override
        @Nullable
        public Component getSearchKey() {
            return this.toTextFunction.apply(this.r);
        }

        @Override
        @Nullable
        public R getSelection() {
            return this.r;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public boolean m_6375_(double mouseX, double mouseY, int int_1) {
            boolean b;
            boolean bl = b = this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
            if (b) {
                this.getEntry().selectionElement.topRenderer.setValue(this.r);
                this.getEntry().selectionElement.m_7522_(null);
                this.getEntry().selectionElement.dontReFocus = true;
                return true;
            }
            return false;
        }
    }

    public static abstract class SelectionCellElement<R>
    extends AbstractContainerEventHandler {
        @Deprecated
        @NotNull
        private DropdownBoxEntry<R> entry;

        @NotNull
        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

        public abstract void dontRender(GuiGraphics var1, float var2);

        @Nullable
        public abstract Component getSearchKey();

        @Nullable
        public abstract R getSelection();
    }

    public static class DefaultSelectionCellCreator<R>
    extends SelectionCellCreator<R> {
        protected Function<R, Component> toTextFunction;

        public DefaultSelectionCellCreator(Function<R, Component> toTextFunction) {
            this.toTextFunction = toTextFunction;
        }

        public DefaultSelectionCellCreator() {
            this(r -> Component.m_237113_((String)r.toString()));
        }

        @Override
        public SelectionCellElement<R> create(R selection) {
            return new DefaultSelectionCellElement<R>(selection, this.toTextFunction);
        }

        @Override
        public int getCellHeight() {
            return 14;
        }

        @Override
        public int getDropBoxMaxHeight() {
            return this.getCellHeight() * 7;
        }
    }
}

