/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ConfigButtonPacket
extends BasePacket {
    private final Setting<?> option;
    private final boolean rotationDirection;

    public ConfigButtonPacket(FriendlyByteBuf stream) {
        this.option = Settings.getOrThrow(stream.m_130277_());
        this.rotationDirection = stream.readBoolean();
    }

    public ConfigButtonPacket(Setting<?> option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130070_(option.getName());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AEBaseMenu baseMenu;
        Object object;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)abstractContainerMenu).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                AELog.info("Ignoring unsupported setting %s sent by client on %s", this.option, baseMenu.getTarget());
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        T currentValue = cm.getSetting(setting);
        T nextValue = EnumCycler.rotateEnum(currentValue, this.rotationDirection, setting.getValues());
        cm.putSetting(setting, nextValue);
    }
}

