/*
 * Decompiled with CFR 0.152.
 */
package fuzs.leavemybarsalone.integration.appleskin;

import fuzs.leavemybarsalone.LeaveMyBarsAlone;
import fuzs.leavemybarsalone.client.handler.RidingBarsHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;

public class AppleSkinIntegration {
    public static void init() {
        Object foodOverlayType;
        MethodHandle renderFoodOrHealthOverlayHandle;
        MethodHandle renderExhaustionHandle;
        try {
            Class<?> renderOverlayTypeClazz = Class.forName("squeek.appleskin.client.HUDOverlayHandler$RenderOverlayType");
            MethodType renderExhaustionType = MethodType.methodType(Void.TYPE, ForgeGui.class, GuiGraphics.class, Float.TYPE, Integer.TYPE, Integer.TYPE);
            MethodType renderFoodOrHealthOverlayType = MethodType.methodType(Void.TYPE, ForgeGui.class, GuiGraphics.class, Float.TYPE, Integer.TYPE, Integer.TYPE, renderOverlayTypeClazz);
            Class<?> clazz = Class.forName("squeek.appleskin.client.HUDOverlayHandler");
            renderExhaustionHandle = MethodHandles.publicLookup().findStatic(clazz, "renderExhaustion", renderExhaustionType);
            renderFoodOrHealthOverlayHandle = MethodHandles.publicLookup().findStatic(clazz, "renderFoodOrHealthOverlay", renderFoodOrHealthOverlayType);
            Field foodField = renderOverlayTypeClazz.getField("FOOD");
            foodField.setAccessible(true);
            MethodHandle foodGetter = MethodHandles.publicLookup().unreflectGetter(foodField);
            foodOverlayType = foodGetter.invoke();
        }
        catch (Throwable e) {
            LeaveMyBarsAlone.LOGGER.warn("Failed to initialize Apple Skin integration", e);
            return;
        }
        MinecraftForge.EVENT_BUS.addListener(evt -> AppleSkinIntegration.onRenderGuiOverlay$Pre(evt, renderExhaustionHandle));
        MinecraftForge.EVENT_BUS.addListener(evt -> AppleSkinIntegration.onRenderGuiOverlay$Post(evt, renderFoodOrHealthOverlayHandle, foodOverlayType));
    }

    private static void onRenderGuiOverlay$Pre(RenderGuiOverlayEvent.Pre evt, MethodHandle methodHandle) {
        if (evt.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)RidingBarsHandler.FOOD_LEVEL_MOUNTED_KEY)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)minecraft.f_91065_;
            if (minecraft.f_91074_.m_20202_() instanceof LivingEntity && !minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                try {
                    methodHandle.invoke(gui, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().m_85443_(), evt.getWindow().m_85444_());
                }
                catch (Throwable e) {
                    LeaveMyBarsAlone.LOGGER.warn("Failed to render Apple Skin exhaustion overlay", e);
                }
            }
        }
    }

    private static void onRenderGuiOverlay$Post(RenderGuiOverlayEvent.Post evt, MethodHandle methodHandle, Object foodOverlayType) {
        if (evt.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)RidingBarsHandler.EXPERIENCE_BAR_MOUNTED_KEY)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)minecraft.f_91065_;
            if (minecraft.f_91074_.m_20202_() instanceof LivingEntity && !minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                try {
                    methodHandle.invoke(gui, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().m_85443_(), evt.getWindow().m_85444_(), foodOverlayType);
                }
                catch (Throwable e) {
                    LeaveMyBarsAlone.LOGGER.warn("Failed to render Apple Skin food overlay", e);
                }
            }
        }
    }
}

