/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorStyleConfigMenu;

public class QuantumArmorStylePacket
implements IMessage<QuantumArmorStylePacket> {
    private List<Integer> slots;
    private int color;

    public QuantumArmorStylePacket() {
    }

    public QuantumArmorStylePacket(List<Integer> slots, int color) {
        this.slots = slots;
        this.color = color;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slots.size());
        for (Integer slotIndex : this.slots) {
            buf.writeInt(slotIndex.intValue());
        }
        buf.writeInt(this.color);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.readInt());
        }
        this.slots = list;
        this.color = buf.readInt();
    }

    public void onMessage(Player serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorStyleConfigMenu) {
            QuantumArmorStyleConfigMenu menu = (QuantumArmorStyleConfigMenu)abstractContainerMenu;
            menu.updateItemColors(this.slots, this.color);
        }
    }

    public Class<QuantumArmorStylePacket> getPacketClass() {
        return QuantumArmorStylePacket.class;
    }

    public boolean isClient() {
        return false;
    }
}

