/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.widgets;

import appeng.api.stacks.GenericStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeSettings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import org.jetbrains.annotations.Nullable;

public record UpgradeState(UpgradeType type, UpgradeSettings settings, boolean enabled, int currentValue, @Nullable List<GenericStack> filter) {
    public UpgradeState(UpgradeType type, UpgradeSettings settings, boolean enabled, int currentValue) {
        this(type, settings, enabled, currentValue, List.of());
    }

    public static UpgradeState fromBytes(FriendlyByteBuf stream) {
        UpgradeType type = (UpgradeType)stream.m_130066_(UpgradeType.class);
        UpgradeSettings settings = UpgradeSettings.fromBytes(stream);
        boolean enabled = stream.readBoolean();
        int currentValue = stream.readInt();
        int size = stream.readInt();
        ArrayList<GenericStack> filter = new ArrayList<GenericStack>();
        for (int i = 0; i < size; ++i) {
            filter.add(GenericStack.readBuffer((FriendlyByteBuf)stream));
        }
        return new UpgradeState(type, settings, enabled, currentValue, filter);
    }

    public void toBytes(FriendlyByteBuf data) {
        data.m_130068_((Enum)this.type);
        this.settings.toBytes(data);
        data.writeBoolean(this.enabled);
        data.writeInt(this.currentValue);
        if (this.filter != null) {
            data.writeInt(this.filter.size());
            for (int i = 0; i < this.filter.size(); ++i) {
                GenericStack.writeBuffer((GenericStack)this.filter.get(i), (FriendlyByteBuf)data);
            }
        }
    }
}

