/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import appeng.api.inventories.InternalInventory;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import org.joml.Quaternionf;

public class ReactionChamberTESR
implements BlockEntityRenderer<ReactionChamberEntity> {
    private final BlockEntityRendererProvider.Context context;
    private static final float ITEM_RENDER_SCALE = 0.4f;
    private static final float L = 0.125f;
    private static final float R = 0.875f;
    private static final float T = 0.6875f;
    private static final float B = 0.125f;
    private static final float FR = 0.125f;
    private static final float BA = 0.875f;
    private static final float[] QUADS = new float[]{0.125f, 0.6875f, 0.125f, 0.875f, 0.125f, 0.125f, 0.875f, 0.6875f, 0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.6875f, 0.875f, 0.125f, 0.125f, 0.125f, 0.875f, 0.6875f, 0.875f, 0.125f, 0.125f, 0.875f, 0.125f, 0.6875f, 0.875f, 0.875f, 0.6875f, 0.125f};
    public static RelativeSide[] SIDES = new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP};

    public ReactionChamberTESR(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    @ParametersAreNonnullByDefault
    public void render(ReactionChamberEntity be, float v, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        FluidStack fluidStack = be.getFluidStack();
        if (fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pos = be.m_58899_();
        FluidState state = fluidStack.getFluid().m_76145_();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation texture = fluidTypeExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        VertexConsumer buffer = buffers.m_6299_(Sheets.m_110792_());
        BlockOrientation orientation = be.getOrientation();
        for (int x = 0; x < QUADS.length; x += 6) {
            float x0 = QUADS[x];
            float y0 = QUADS[x + 1];
            float z0 = QUADS[x + 2];
            float x1 = QUADS[x + 3];
            float y1 = QUADS[x + 4];
            float z1 = QUADS[x + 5];
            Direction face = orientation.getSide(SIDES[x / 6]);
            poseStack.m_85836_();
            ReactionChamberTESR.drawQuad(buffer, poseStack, x0, y0, z0, x1, y1, z1, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), light, overlay, tintColor, face);
            poseStack.m_85849_();
        }
        InternalInventory inv = be.getInput();
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack stack = inv.getStackInSlot(x);
            if (stack.m_41619_()) continue;
            this.renderItem(poseStack, stack, x, buffers, light, overlay);
        }
    }

    private static void drawQuad(VertexConsumer buffer, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int light, int overlay, int color, Direction front) {
        if (front != Direction.UP && front != Direction.DOWN) {
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z0, u0, v0, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y0, z1, u0, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z1, u1, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y1, z0, u1, v0, front, light, overlay, color);
        } else {
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z0, u0, v0, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z0, u0, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z1, u1, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z1, u1, v0, front, light, overlay, color);
        }
    }

    private static void drawVertex(VertexConsumer buffer, PoseStack poseStack, float x, float y, float z, float u, float v, Direction front, int light, int overlay, int color) {
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z);
        buffer.m_193479_(color);
        buffer.m_7421_(u, v);
        buffer.m_86008_(overlay);
        buffer.m_85969_(light);
        ReactionChamberTESR.setNormal(buffer, poseStack, front);
        buffer.m_5752_();
    }

    private void renderItem(PoseStack ms, ItemStack stack, int index, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        if (!stack.m_41619_()) {
            ms.m_85836_();
            float duration = 10000.0f;
            long t = System.currentTimeMillis() % (long)((int)duration);
            float angle = (float)t / (duration / 360.0f) + (float)(index * 120);
            ms.m_272245_(new Quaternionf().rotationY((float)Math.PI / 180 * angle), 0.5f, 0.0f, 0.5f);
            float yOffset = ReactionChamberTESR.itemYPosition(t, duration) / 12.0f;
            ms.m_85837_(0.25, 0.5875 + (double)yOffset, 0.5);
            ms.m_85841_(0.4f, 0.4f, 0.4f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, ms, buffers, (Level)Minecraft.m_91087_().f_91073_, 0);
            ms.m_85849_();
        }
    }

    private static void setNormal(VertexConsumer buffer, PoseStack poseStack, Direction front) {
        buffer.m_252939_(poseStack.m_85850_().m_252943_(), (float)front.m_122429_(), (float)front.m_122430_(), (float)front.m_122431_());
    }

    private static float itemYPosition(long x, float max) {
        float rad = (float)(x * 2L) * (float)Math.PI / max;
        return Mth.m_14089_((float)rad);
    }
}

