/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChestBlock
extends WoodStorageBlockBase
implements SimpleWaterloggedBlock,
IDoubleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.f_61392_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, 2.5f);
    }

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.5f, explosionResistance).m_60918_(SoundType.f_56736_), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)ChestType.SINGLE));
    }

    public static boolean isChestBlockedAt(LevelAccessor level, BlockPos pos) {
        return ChestBlock.isBlockedChestByBlock((BlockGetter)level, pos) || ChestBlock.isCatSittingOnChest(level, pos);
    }

    private static boolean isBlockedChestByBlock(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return level.m_8055_(blockpos).m_60796_(level, blockpos);
    }

    public static Direction getConnectedDirection(BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        return blockState.m_61143_(TYPE) == ChestType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    private static boolean isCatSittingOnChest(LevelAccessor level, BlockPos pos) {
        List list = level.m_45976_(Cat.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 1.0));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (level.m_141902_(currentPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(StorageBlockEntity::isBeingUpgraded).orElse(false).booleanValue()) {
            return state;
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (this.isSameChest(facingState, level, currentPos, facingPos) && facing.m_122434_().m_122479_()) {
            ChestType chesttype = (ChestType)facingState.m_61143_(TYPE);
            if (state.m_61143_(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.m_61143_((Property)FACING) == facingState.m_61143_((Property)FACING) && ChestBlock.getConnectedDirection(facingState) == facing.m_122424_()) {
                level.m_141902_(currentPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                    Block patt6171$temp = state.m_60734_();
                    if (patt6171$temp instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt6171$temp;
                        if (be.getStorageWrapper().getInventoryHandler().getSlots() <= chestBlock.getNumberOfInventorySlots()) {
                            ChestBlock.joinWithChest(level, facingPos, chesttype.m_61486_(), be);
                        }
                    }
                    if (be.isMainChest()) {
                        be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
                    }
                });
                return (BlockState)state.m_61124_(TYPE, (Comparable)chesttype.m_61486_());
            }
        } else if (ChestBlock.getConnectedDirection(state) == facing) {
            level.m_141902_(currentPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                if (!(level.m_5776_() || be.isBeingUpgraded() || be.isPacked())) {
                    Block patt6837$temp;
                    if (be.isMainChest() && (patt6837$temp = state.m_60734_()) instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt6837$temp;
                        be.dropSecondPartContents(chestBlock, facingPos);
                    } else if (!be.isMainChest()) {
                        be.removeDoubleMainPos();
                    }
                }
            });
            return (BlockState)state.m_61124_(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    private boolean isSameChest(BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!facingState.m_60713_((Block)this)) {
            return false;
        }
        return level.m_141902_(facingPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).flatMap(facingBE -> level.m_141902_(currentPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(currentBE -> currentBE.isPacked() == facingBE.isPacked() && currentBE.getStorageWrapper().getMainColor() == facingBE.getStorageWrapper().getMainColor() && currentBE.getStorageWrapper().getAccentColor() == facingBE.getStorageWrapper().getAccentColor() && currentBE.getWoodType().orElse(WoodType.f_61833_) == facingBE.getWoodType().orElse(WoodType.f_61833_))).orElse(false);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        return switch (ChestBlock.getConnectedDirection(state)) {
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> NORTH_AABB;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        ItemStack chestBeingPlaced = context.m_43722_();
        if (ChestBlockItem.isDoubleChest(chestBeingPlaced)) {
            BlockPos otherPartPos = context.m_8083_().m_121945_(context.m_8125_().m_122427_());
            Level level = context.m_43725_();
            if (!level.m_8055_(otherPartPos).m_60629_(context) || !level.m_6857_().m_61937_(otherPartPos)) {
                return null;
            }
        }
        Direction direction = context.m_8125_().m_122424_();
        return chestBeingPlaced.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).filter(StackStorageWrapper::hasContents).map(wrapper -> this.getStateForPlacement(context, direction, fluidstate, StorageBlockItem.getMainColorFromStack(chestBeingPlaced).orElse(-1), StorageBlockItem.getAccentColorFromStack(chestBeingPlaced).orElse(-1), WoodStorageBlockItem.getWoodType(chestBeingPlaced).orElse(WoodType.f_61833_), InventoryHelper.isEmpty((IItemHandler)wrapper.getUpgradeHandler()))).orElse(this.getStateForPlacement(context, direction, fluidstate, StorageBlockItem.getMainColorFromStack(chestBeingPlaced).orElse(-1), StorageBlockItem.getAccentColorFromStack(chestBeingPlaced).orElse(-1), WoodStorageBlockItem.getWoodType(chestBeingPlaced).orElse(WoodType.f_61833_), true));
    }

    private BlockState getStateForPlacement(BlockPlaceContext context, Direction direction, FluidState fluidstate, int mainColor, int accentColor, WoodType woodType, boolean itemHasNoUpgrades) {
        Direction partnerFacing;
        ChestType chestType = ChestType.SINGLE;
        Direction clickedFace = context.m_43719_();
        boolean isHoldingSneak = context.m_7078_();
        if (clickedFace.m_122434_().m_122479_() && isHoldingSneak && (partnerFacing = this.candidatePartnerFacing(context, clickedFace.m_122424_(), mainColor, accentColor, woodType, itemHasNoUpgrades)) != null && partnerFacing.m_122434_() != clickedFace.m_122434_()) {
            direction = partnerFacing;
            ChestType chestType2 = chestType = partnerFacing.m_122428_() == clickedFace.m_122424_() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chestType == ChestType.SINGLE && !isHoldingSneak) {
            if (direction == this.candidatePartnerFacing(context, direction.m_122427_(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(context, direction.m_122428_(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)chestType)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction, int mainColor, int accentColor, WoodType woodType, boolean itemHasNoUpgrades) {
        BlockPos neighborChestPos = context.m_8083_().m_121945_(direction);
        BlockState blockstate = context.m_43725_().m_8055_(neighborChestPos);
        if (!blockstate.m_60713_((Block)this) || blockstate.m_61143_(TYPE) != ChestType.SINGLE) {
            return null;
        }
        if (context.m_43725_().m_141902_(neighborChestPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(be -> mainColor == be.getStorageWrapper().getMainColor() && accentColor == be.getStorageWrapper().getAccentColor() && woodType == be.getWoodType().orElse(WoodType.f_61833_) && (itemHasNoUpgrades || InventoryHelper.isEmpty((IItemHandler)be.getStorageWrapper().getUpgradeHandler()))).orElse(false).booleanValue()) {
            return (Direction)blockstate.m_61143_((Property)FACING);
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? ChestBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get(), (l, p, s, be) -> ChestBlockEntity.lidAnimateTick(be)) : super.m_142354_(level, state, blockEntityType);
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (ChestBlock.isChestBlockedAt((LevelAccessor)level, pos) || state.m_61143_(TYPE) != ChestType.SINGLE && ChestBlock.isChestBlockedAt((LevelAccessor)level, pos.m_121945_(ChestBlock.getConnectedDirection(state)))) {
            return InteractionResult.PASS;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(b -> {
            BlockPos mainChestPos;
            ItemStack stackInHand = player.m_21120_(hand);
            if (!b.isMainChest()) {
                mainChestPos = pos.m_121945_(ChestBlock.getConnectedDirection(state));
                b = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)mainChestPos, ChestBlockEntity.class).orElse(b);
            } else {
                mainChestPos = pos;
            }
            if (b.isPacked()) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_ || hand == InteractionHand.OFF_HAND) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryItemInteraction(player, hand, (WoodStorageBlockEntity)b, stackInHand, (Direction)state.m_61143_((Property)FACING), hitResult)) {
                return InteractionResult.SUCCESS;
            }
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, mainChestPos), b.m_5446_()), (BlockPos)mainChestPos);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ChestType chestType;
        super.m_6402_(level, pos, state, placer, stack);
        if (ChestBlockItem.isDoubleChest(stack) && !level.m_5776_()) {
            BlockPos otherPartPos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122428_());
            level.m_7731_(otherPartPos, (BlockState)state.m_61124_(TYPE, (Comparable)ChestType.LEFT), 3);
            level.m_141902_(otherPartPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
                be.setMainPos(pos);
                be.tryToAddToController();
            });
        }
        if ((chestType = (ChestType)state.m_61143_(TYPE)) == ChestType.SINGLE || level.m_5776_()) {
            return;
        }
        BlockPos otherPos = pos.m_121945_(ChestBlock.getConnectedDirection(state));
        ChestBlock.joinChests((LevelAccessor)level, pos, otherPos, chestType);
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    private static void joinChests(LevelAccessor level, BlockPos pos, BlockPos otherPos, ChestType currentChestType) {
        level.m_141902_(pos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(currentBE -> ChestBlock.joinWithChest(level, otherPos, currentChestType, currentBE));
    }

    private static void joinWithChest(LevelAccessor level, BlockPos otherPos, ChestType currentChestType, ChestBlockEntity currentBE) {
        level.m_141902_(otherPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(otherBE -> {
            if (InventoryHelper.isEmpty((IItemHandler)currentBE.getStorageWrapper().getUpgradeHandler()) && (currentChestType == ChestType.LEFT || !InventoryHelper.isEmpty((IItemHandler)otherBE.getStorageWrapper().getUpgradeHandler()))) {
                currentBE.joinWithChest((ChestBlockEntity)otherBE);
                currentBE.syncTogglesFrom((ChestBlockEntity)otherBE);
            } else {
                otherBE.joinWithChest(currentBE);
                otherBE.syncTogglesFrom(currentBE);
            }
        });
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (state.m_61143_(TYPE) != ChestType.SINGLE) {
            level.m_141902_(pos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                be.setDestroyedByPlayer();
                if ((be.isPacked() || Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) && !be.isMainChest()) {
                    BlockPos otherPartPos = pos.m_121945_(ChestBlock.getConnectedDirection(state));
                    level.m_141902_(otherPartPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBe -> {
                        be.getStorageWrapper().load(mainBe.getStorageWrapper().save(new CompoundTag()));
                        CompoundTag contentsTag = new CompoundTag();
                        contentsTag.m_128365_("contents", (Tag)new CompoundTag());
                        mainBe.getStorageWrapper().load(contentsTag);
                    });
                }
            });
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_61143_(TYPE) != ChestType.SINGLE) {
            level.m_141902_(pos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                if (be.isPacked()) {
                    level.m_7471_(pos.m_121945_(ChestBlock.getConnectedDirection(state)), false);
                }
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        ChestBlockEntity chestBlockEntity;
        if (be instanceof ChestBlockEntity && (chestBlockEntity = (ChestBlockEntity)be).isPacked() && be.m_58900_().m_61143_(TYPE) != ChestType.SINGLE) {
            super.addDropData(stack, be);
            ChestBlockItem.setDoubleChest(stack, true);
        } else {
            super.addDropData(stack, be);
        }
    }

    @Override
    protected void packStorage(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        super.packStorage(player, hand, b, stackInHand);
        if (b.m_58900_().m_61143_(TYPE) == ChestType.SINGLE) {
            return;
        }
        player.m_9236_().m_141902_(b.m_58899_().m_121945_(ChestBlock.getConnectedDirection(b.m_58900_())), (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> super.packStorage(player, hand, (WoodStorageBlockEntity)be, stackInHand));
    }

    @Override
    @Nullable
    public ChestBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChestBlockEntity(pos, state);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, TICKING, TYPE});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    @Override
    public List<BlockPos> getNeighborPos(BlockState state, BlockPos origin, Direction facing) {
        if (state.m_61143_(TYPE) == ChestType.SINGLE) {
            return List.of(origin.m_121945_(facing));
        }
        Direction connectedDirection = ChestBlock.getConnectedDirection(state);
        if (connectedDirection == facing) {
            return List.of(origin.m_121945_(facing).m_121945_(facing));
        }
        if (connectedDirection.m_122424_() == facing) {
            return List.of(origin.m_121945_(facing));
        }
        return List.of(origin.m_121945_(facing), origin.m_121945_(connectedDirection).m_121945_(facing));
    }

    public Optional<BlockPos> getOtherPosition(BlockState state, BlockPos pos) {
        return state.m_61143_(TYPE) == ChestType.SINGLE ? Optional.empty() : Optional.of(pos.m_121945_(ChestBlock.getConnectedDirection(state)));
    }

    @Override
    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (state.m_61143_(TYPE) != ChestType.SINGLE && pos.m_121945_(ChestBlock.getConnectedDirection(state)).equals((Object)neighbor)) {
            return;
        }
        super.onNeighborChange(state, level, pos, neighbor);
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, ChestBlockEntity.class).ifPresent(te -> this.tryToPickup(world, itemEntity, te.getMainStorageWrapper()));
        }
    }

    @Override
    protected Vector3f getMiddleFacePoint(BlockState state, BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        float xOffset = 0.0f;
        ChestType type = (ChestType)state.m_61143_(TYPE);
        if (type == ChestType.LEFT) {
            xOffset = -0.5f;
        } else if (type == ChestType.RIGHT) {
            xOffset = 0.5f;
        }
        point.add(xOffset, 0.0f, 0.6f);
        point.rotate((Quaternionfc)Axis.f_252529_.m_252977_(-90.0f));
        point.rotate((Quaternionfc)facing.m_253075_());
        point.add((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        return point;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public boolean tryFillUpgrades(Player player, InteractionHand hand, Level level, BlockPos pos, ItemStack itemInHand) {
        return super.tryFillUpgrades(player, hand, level, WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(ChestBlockEntity::getMainPos).orElse(pos), itemInHand);
    }

    @Override
    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(be -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)be.getMainStorageWrapper().getInventoryForInputOutput())).orElse(0);
    }
}

