/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import java.nio.file.Path;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.api.events.FastModelSettingsUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="chloride")
public class FastBlocks {
    public static Pack SOLID_BEDS_PACK;
    public static Pack SOLID_CHESTS_PACK;

    public static boolean canUseOnChests() {
        return !Chloride.installed("enhancedblockentities");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChestSettingUpdateEvent(FastModelSettingsUpdate.ChestEvent e) {
        if (e.isEnabled()) {
            Minecraft.m_91087_().m_91099_().m_275855_(SOLID_CHESTS_PACK.m_10446_());
        } else {
            Minecraft.m_91087_().m_91099_().m_275853_(SOLID_CHESTS_PACK.m_10446_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBedSettingUpdateEvent(FastModelSettingsUpdate.BedEvent e) {
        if (e.isEnabled()) {
            Minecraft.m_91087_().m_91099_().m_275855_(SOLID_BEDS_PACK.m_10446_());
        } else {
            Minecraft.m_91087_().m_91099_().m_275853_(SOLID_BEDS_PACK.m_10446_());
        }
    }

    private static PathPackResources getPathResources(String packId, final String path) {
        final IModFile modFile = ModList.get().getModFileById("chloride").getFile();
        return new PathPackResources(packId, true, modFile.findResource(new String[]{path})){

            @NotNull
            protected Path resolve(String ... paths) {
                String[] allPaths = new String[paths.length + 1];
                allPaths[0] = path;
                System.arraycopy(paths, 0, allPaths, 1, paths.length);
                return modFile.findResource(allPaths);
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="chloride")
    public static final class ModEvents {
        @SubscribeEvent
        public static void registerResourcePacks(AddPackFindersEvent e) {
            Chloride.LOGGER.info("Registering CHLORIDE built-in packs");
            if (e.getPackType() == PackType.CLIENT_RESOURCES) {
                SOLID_BEDS_PACK = Pack.m_245429_((String)"chloride_solid_beds", (Component)Component.m_237113_((String)"Chloride: Solid Beds"), (boolean)false, id -> FastBlocks.getPathResources(id, "custom_packs/solid_beds"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                SOLID_CHESTS_PACK = Pack.m_245429_((String)"chloride_solid_chests", (Component)Component.m_237113_((String)"Chloride: Solid Chests"), (boolean)false, id -> FastBlocks.getPathResources(id, "custom_packs/solid_chests"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                e.addRepositorySource(consumer -> {
                    consumer.accept(SOLID_BEDS_PACK);
                    consumer.accept(SOLID_CHESTS_PACK);
                });
            }
        }
    }
}

