/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.widget;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.client.screen.Texture;

public class IconButton
extends Button {
    protected final Minecraft mc = Minecraft.m_91087_();
    @Nullable
    private Supplier<List<Component>> tooltipSupplier;
    private Screen screen;
    private Texture texture;
    private Texture hovering;
    private ItemStack stack;
    private float xOffset;
    private float yOffset;
    @Nullable
    private SoundEvent sound;
    public static final IconButton EMPTY = new IconButton(0, 0, Texture.EMPTY, b -> {}, (Screen)new ChatScreen(""));

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, Texture.EMPTY, text, onPress, screen);
    }

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Texture hovering, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, hovering, text, onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, Texture.EMPTY, (Component)Component.m_237119_(), onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, hovering, (Component)Component.m_237119_(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, Texture.EMPTY, (Component)Component.m_237119_(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, hovering, (Component)Component.m_237119_(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Component text, Button.OnPress onPress, Screen screen) {
        super(x, y, texture.getWidth(), texture.getHeight(), text, onPress, f_252438_);
        this.texture = texture;
        this.screen = screen;
        this.hovering = hovering;
        this.stack = stack;
    }

    protected void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float pt) {
        if (this.f_93622_) {
            this.m_257544_(this.createTooltip());
        }
        if (this.f_93622_ && !this.hovering.isEmpty()) {
            this.hovering.draw(gui, this.m_252754_(), this.m_252907_());
        } else {
            this.texture.draw(gui, this.m_252754_(), this.m_252907_());
        }
        Font f = this.mc.f_91062_;
        String s = this.m_6035_().getString();
        if (!s.isEmpty()) {
            int width = f.m_92895_(s);
            TextColor c = this.m_6035_().m_7383_().m_131135_();
            int color = c == null ? 0x555555 : c.m_131265_();
            gui.m_280056_(f, s, Math.round(this.xOffset + (float)this.m_252754_() + 0.5f + (float)this.f_93618_ / 2.0f - (float)width / 2.0f), Math.round(this.yOffset + (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 4.0f), color, false);
        }
        if (!this.stack.m_41619_()) {
            int x = (int)Math.round((double)(this.xOffset + (float)this.m_252754_()) - 8.0 + (double)((float)this.f_93618_ / 2.0f));
            int y = (int)Math.round((double)(this.yOffset + (float)this.m_252907_()) - 8.0 + (double)((float)this.f_93619_ / 2.0f));
            gui.m_280203_(this.stack, x, y);
            gui.m_280370_(f, this.stack, x, y);
        }
    }

    @Nullable
    private Tooltip createTooltip() {
        if (this.tooltipSupplier == null) {
            return null;
        }
        return this.tooltipSupplier.get().stream().reduce((component, component2) -> component.m_6881_().m_130946_("\n").m_7220_(component2)).map(Tooltip::m_257550_).orElse(null);
    }

    public void blit(GuiGraphics gui, Texture texture, int x, int y) {
        gui.m_280218_(texture.getLocation(), x, y, texture.getU(), texture.getV(), texture.getWidth(), texture.getHeight());
    }

    public Screen getScreen() {
        return this.screen;
    }

    public IconButton setScreen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public IconButton setTexture(Texture texture) {
        this.texture = texture;
        return this;
    }

    public Texture getHovering() {
        return this.hovering;
    }

    public IconButton setHovering(Texture hovering) {
        this.hovering = hovering;
        return this;
    }

    public IconButton setTooltip(Component component) {
        super.m_257544_(Tooltip.m_257550_((Component)component));
        return this;
    }

    public IconButton setTooltipSupplier(Supplier<List<Component>> supplier) {
        this.tooltipSupplier = supplier;
        return this;
    }

    public IconButton setStackInSlot(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public IconButton xOffset(float xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public IconButton yOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public void m_7435_(SoundManager handler) {
        if (this.sound != null) {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.sound, (float)1.0f));
        }
    }

    public IconButton setClickSound() {
        this.sound = (SoundEvent)SoundEvents.f_12490_.m_203334_();
        return this;
    }

    public IconButton setSound(@Nullable SoundEvent sound) {
        this.sound = sound;
        return this;
    }
}

