/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.javd.util;

import com.unrealdinnerbone.javd.JAVDRegistry;
import com.unrealdinnerbone.javd.block.PortalBlock;
import com.unrealdinnerbone.javd.block.PortalTileEntity;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class TelerportUtils {
    public static void teleport(Player playerEntity, ResourceKey<Level> toWorldKey, BlockPos blockPos, boolean spawnPlatform) {
        ServerLevel toWorld = playerEntity.m_20194_().m_129880_(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((Level)toWorld, blockPos).ifPresentOrElse(portalLocation -> {
                if (toWorld.m_8055_(portalLocation).m_60795_()) {
                    toWorld.m_46597_(portalLocation, ((PortalBlock)((Object)((Object)JAVDRegistry.PORTAL_BLOCK.get()))).m_49966_());
                    Block block = BuiltInRegistries.f_256975_.m_203431_(JAVDRegistry.GENERATOR_BLOCKS).map(named -> named.m_213653_(toWorld.m_213780_())).filter(Optional::isPresent).map(Optional::get).map(Holder::m_203334_).orElse(Blocks.f_50069_);
                    int range = 3;
                    BlockPos.m_121990_((BlockPos)portalLocation.m_7918_(range, 0, range), (BlockPos)portalLocation.m_7918_(-range, 0, -range)).forEach(blockPos1 -> {
                        if (toWorld.m_8055_(blockPos1).m_60795_()) {
                            toWorld.m_46597_(blockPos1, block.m_49966_());
                        }
                    });
                }
                Vec3 portalLocationVec = new Vec3((double)portalLocation.m_123341_() + 0.5, (double)(portalLocation.m_123342_() + 1), (double)portalLocation.m_123343_() + 0.5);
                Services.PLATFORM.teleport((Entity)playerEntity, toWorld, new PortalInfo(portalLocationVec, playerEntity.m_20184_(), playerEntity.m_146908_(), playerEntity.m_146909_()));
            }, () -> playerEntity.m_5661_((Component)Component.m_237115_((String)"javd.invalid.pos"), true));
        } else {
            playerEntity.m_5661_((Component)Component.m_237110_((String)"javd.invalid.world", (Object[])new Object[]{toWorldKey.m_135782_().toString()}), true);
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos) {
        if (worldTo.m_8055_(fromPos).m_60734_() == JAVDRegistry.PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.m_7494_());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.m_45596_((ChunkPos)worldTo.m_46745_(fromPos).m_7697_(), (int)range).map(chunkPos -> worldTo.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_5928_()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.m_7702_(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            int y;
            int maxY;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
            int minY = worldTo.m_141937_();
            int start = minY + (maxY = worldTo.m_151558_());
            if (start != 0) {
                start /= 2;
            }
            for (y = start - 1; y > minY; --y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.m_123341_(), fromPos.m_123343_(), y)) continue;
                return mutableBlockPos;
            }
            for (y = start; y < maxY; ++y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.m_123341_(), fromPos.m_123343_(), y)) continue;
                return mutableBlockPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(Level levelTo, BlockPos.MutableBlockPos blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.m_122178_(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(Level levelTo, BlockPos.MutableBlockPos blockPos) {
        BlockState blockState = levelTo.m_8055_((BlockPos)blockPos);
        return blockState.m_60795_() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.m_7494_());
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.m_46739_(blockPos) && world.m_8055_(blockPos).m_60795_() && world.m_8055_(blockPos.m_7494_()).m_60795_();
    }
}

