/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.cobalt.registration.CobaltFuelRegistry;
import immersive_aircraft.config.Config;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Utils {
    public static double cosNoise(double time) {
        return Utils.cosNoise(time, 5);
    }

    public static double cosNoise(double time, int layers) {
        double value = 0.0;
        for (int i = 0; i < layers; ++i) {
            value += Math.cos(time);
            time *= 1.3;
        }
        return value;
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> parseBannerItem(ItemStack banner) {
        DyeColor baseColor = ((BannerItem)banner.m_41720_()).m_40545_();
        CompoundTag nbtCompound = BlockItem.m_186336_((ItemStack)banner);
        if (nbtCompound == null || !nbtCompound.m_128441_("Patterns")) {
            return List.of(Pair.of((Object)BuiltInRegistries.f_256878_.m_246971_(BannerPatterns.f_222726_), (Object)baseColor));
        }
        ListTag nbtList = nbtCompound.m_128437_("Patterns", 10);
        return BannerBlockEntity.m_58484_((DyeColor)baseColor, (ListTag)nbtList);
    }

    public static int getFuelTime(ItemStack fuel) {
        int fuelTime;
        if (fuel.m_41619_()) {
            return 0;
        }
        Map<String, Integer> fuelList = Config.getInstance().fuelList;
        String identifier = BuiltInRegistries.f_257033_.m_7981_((Object)fuel.m_41720_()).toString();
        if (fuelList.containsKey(identifier)) {
            return fuelList.get(identifier);
        }
        if (Config.getInstance().acceptVanillaFuel && (fuelTime = CobaltFuelRegistry.INSTANCE.get(fuel)) > 0) {
            return fuelTime;
        }
        return 0;
    }

    public static boolean getBooleanElement(JsonObject object, String member) {
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return false;
        }
        return element.getAsBoolean();
    }

    public static boolean isNull(JsonObject object, String member) {
        return object.has(member) && object.get(member).isJsonNull();
    }

    public static int getIntElement(JsonObject object, String member) {
        return Utils.getIntElement(object, member, 0);
    }

    public static int getIntElement(JsonObject object, String member, int defaultValue) {
        JsonPrimitive primitive;
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return defaultValue;
        }
        if (element instanceof JsonPrimitive && (primitive = element).isNumber()) {
            return primitive.getAsInt();
        }
        return defaultValue;
    }

    public static float getFloatElement(JsonObject object, String member) {
        return Utils.getFloatElement(object, member, 0.0f);
    }

    public static float getFloatElement(JsonObject object, String member, float defaultValue) {
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return defaultValue;
        }
        return element.getAsFloat();
    }

    public static Vector3f parseVector(JsonObject element, String member) {
        JsonArray array = element.getAsJsonArray(member);
        if (array == null) {
            return new Vector3f();
        }
        return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    public static Quaternionf fromXYZ(float pitch, float yaw, float roll) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotationZYX(roll, yaw, pitch);
        return quaternion;
    }

    public static Quaternionf fromXYZ(Vector3f rotation) {
        return Utils.fromXYZ(rotation.x, rotation.y, rotation.z);
    }
}

