/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util;

public class InterpolatedFloat {
    private float value;
    private float last;
    private float valueSmooth;
    private float lastSmooth;
    private float steps;

    public InterpolatedFloat(float steps) {
        this.steps = 1.0f / steps;
    }

    public InterpolatedFloat() {
        this(5.0f);
    }

    public void update(float n) {
        this.last = this.value;
        this.value = n;
        this.lastSmooth = this.valueSmooth;
        this.decay(n, this.steps);
    }

    public void decay(float towards, float decay) {
        this.valueSmooth = this.valueSmooth * (1.0f - decay) + towards * decay;
    }

    public void setSteps(float steps) {
        this.steps = 1.0f / steps;
    }

    public float get(float tickDelta) {
        return this.last + tickDelta * (this.value - this.last);
    }

    public float getSmooth(float tickDelta) {
        return this.lastSmooth + tickDelta * (this.valueSmooth - this.lastSmooth);
    }

    public float getSmooth() {
        return this.valueSmooth;
    }

    public float getValue() {
        return this.value;
    }

    public float getDiff() {
        return this.value - this.last;
    }
}

