/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public interface IERecipes {
    public static final RecipeComponent<ClocheRenderFunction.ClocheRenderReference> RENDER_COMPONENT = new RecipeComponent<ClocheRenderFunction.ClocheRenderReference>(){

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return ClocheRenderFunction.ClocheRenderReference.class;
        }

        public JsonElement write(RecipeJS recipe, ClocheRenderFunction.ClocheRenderReference value) {
            return value.serialize();
        }

        public ClocheRenderFunction.ClocheRenderReference read(RecipeJS recipe, Object from) {
            if (from instanceof Block) {
                Block block = (Block)from;
                return new ClocheRenderFunction.ClocheRenderReference("crop", block);
            }
            return ClocheRenderFunction.ClocheRenderReference.deserialize((JsonObject)MapJS.json((Object)from));
        }
    };
    public static final RecipeComponent<HeatSource> HEAT_SOURCE_COMPONENT = new RecipeComponent<HeatSource>(){

        public Class<?> componentClass() {
            return HeatSource.class;
        }

        public JsonElement write(RecipeJS recipe, HeatSource value) {
            throw new RecipeExceptionJS("Heat Source component can't be written");
        }

        public HeatSource read(RecipeJS recipe, Object from) {
            if (from instanceof HeatSource) {
                HeatSource s = (HeatSource)from;
                return s;
            }
            if (from instanceof CharSequence) {
                String s = from.toString();
                if (s.startsWith("#")) {
                    return new HeatSource(new ResourceLocation(s.substring(1)), true);
                }
                return new HeatSource(new ResourceLocation(s), false);
            }
            if (from instanceof Block) {
                return new HeatSource(new ResourceLocation(((Block)from).kjs$getId()), false);
            }
            throw new RecipeExceptionJS("Can't parse HeatSource from " + from);
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<HeatSource> value, JsonObject json) {
            if (((HeatSource)value.value).tag) {
                json.addProperty("blockTag", ((HeatSource)value.value).id.toString());
            } else {
                json.addProperty("singleBlock", ((HeatSource)value.value).id.toString());
            }
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<HeatSource> cv, JsonObject json) {
            cv.value = json.has("blockTag") ? new HeatSource(new ResourceLocation(json.get("blockTag").getAsString()), true) : new HeatSource(new ResourceLocation(json.get("singleBlock").getAsString()), false);
        }

        public void readFromMap(RecipeJS recipe, RecipeComponentValue<HeatSource> cv, Map<?, ?> map) {
            cv.value = map.containsKey("blockTag") ? new HeatSource(new ResourceLocation(map.get("blockTag").toString()), true) : new HeatSource(new ResourceLocation(map.get("singleBlock").toString()), false);
        }
    };
    public static final RecipeComponent<BiomeFilter> BIOME_FILTER_COMPONENT = new RecipeComponent<BiomeFilter>(){

        public Class<?> componentClass() {
            return BiomeFilter.class;
        }

        public JsonElement write(RecipeJS recipe, BiomeFilter value) {
            throw new RecipeExceptionJS("Biome filter component can't be written");
        }

        public BiomeFilter read(RecipeJS recipe, Object from) {
            if (from instanceof BiomeFilter) {
                BiomeFilter s = (BiomeFilter)from;
                return s;
            }
            if (from instanceof CharSequence) {
                String s = from.toString();
                if (s.startsWith("#")) {
                    return new BiomeFilter(new ResourceLocation(s.substring(1)), true);
                }
                return new BiomeFilter(new ResourceLocation(s), false);
            }
            if (from instanceof Biome) {
                Biome biome = (Biome)from;
                return new BiomeFilter(KubeJSRegistries.biomes().getId((Object)biome), false);
            }
            throw new RecipeExceptionJS("Can't parse HeatSource from " + from);
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<BiomeFilter> value, JsonObject json) {
            if (((BiomeFilter)value.value).tag) {
                json.addProperty("biomeTag", ((BiomeFilter)value.value).id.toString());
            } else {
                json.addProperty("singleBiome", ((BiomeFilter)value.value).id.toString());
            }
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<BiomeFilter> cv, JsonObject json) {
            cv.value = json.has("biomeTag") ? new BiomeFilter(new ResourceLocation(json.get("biomeTag").getAsString()), true) : new BiomeFilter(new ResourceLocation(json.get("singleBiome").getAsString()), false);
        }

        public void readFromMap(RecipeJS recipe, RecipeComponentValue<BiomeFilter> cv, Map<?, ?> map) {
            cv.value = map.containsKey("biomeTag") ? new BiomeFilter(new ResourceLocation(map.get("biomeTag").toString()), true) : new BiomeFilter(new ResourceLocation(map.get("singleBiome").toString()), false);
        }
    };

    public static RecipeKey<Long> time() {
        return TimeComponent.TICKS.key("time");
    }

    public static RecipeKey<Long> time(long def) {
        return IERecipes.time().optional((Object)def).alwaysWrite();
    }

    public static RecipeKey<Integer> energy() {
        return NumberComponent.INT.key("energy");
    }

    public static RecipeKey<Integer> energy(int def) {
        return IERecipes.energy().optional((Object)def).alwaysWrite();
    }

    public record BiomeFilter(ResourceLocation id, boolean tag) {
    }

    public record HeatSource(ResourceLocation id, boolean tag) {
    }
}

