/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.HashMap;

public record ColorUtil() {
    private static final HashMap<Integer, float[]> COLOR_CACHE = new HashMap();

    public static float[] getColorForBlock(int color) {
        if (!COLOR_CACHE.containsKey(color)) {
            int l = (color & 0xFF0000) >> 16;
            int m = (color & 0xFF00) >> 8;
            int n = color & 0xFF;
            COLOR_CACHE.put(color, new float[]{(float)l / 255.0f, (float)m / 255.0f, (float)n / 255.0f});
        }
        return COLOR_CACHE.get(color);
    }

    public static int getColorFromRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

