/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class VanillaPortalAreaHelper
extends PortalFrameTester {
    protected Direction.Axis axis;
    protected int height;
    protected int width;
    protected final int maxWidth = 21;
    protected final int maxHeight = 21;

    @Override
    public PortalFrameTester init(LevelAccessor world, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.axis = axis;
        this.lowerCorner = this.getLowerCorner(blockPos, axis, Direction.Axis.Y);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.height = 1;
            this.width = 1;
        } else {
            this.width = this.getSize(axis, 2, 21);
            if (this.width > 0) {
                this.height = this.getSize(Direction.Axis.Y, 3, 21);
                if (this.checkForValidFrame(axis, Direction.Axis.Y, this.width, this.height)) {
                    this.countExistingPortalBlocks(axis, Direction.Axis.Y, this.width, this.height);
                } else {
                    this.lowerCorner = null;
                    this.height = 1;
                    this.width = 1;
                }
            }
        }
        return this;
    }

    @Override
    public BlockUtil.FoundRectangle getRectangle() {
        return new BlockUtil.FoundRectangle(this.lowerCorner, this.width, this.height);
    }

    @Override
    public Direction.Axis getAxis1() {
        return this.axis;
    }

    @Override
    public Direction.Axis getAxis2() {
        return Direction.Axis.Y;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(LevelAccessor worldAccess, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, customAreaHelper -> customAreaHelper.isValidFrame() && customAreaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(LevelAccessor worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Block ... foundations) {
        Optional<PortalFrameTester> optional = Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis axis2 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis2, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.width * this.height;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return !(attemptWidth != 0 && this.width != attemptWidth || attemptHeight != 0 && this.height != attemptHeight);
    }

    @Override
    public BlockPos doesPortalFitAt(Level world, BlockPos attemptPos, Direction.Axis axis) {
        if (this.isEmptySpace(world.m_8055_(attemptPos)) && this.isEmptySpace(world.m_8055_(attemptPos.m_5487_(axis, 1))) && this.isEmptySpace(world.m_8055_(attemptPos.m_7494_())) && this.isEmptySpace(world.m_8055_(attemptPos.m_5487_(axis, 1).m_7494_())) && this.isEmptySpace(world.m_8055_(attemptPos.m_6630_(2))) && this.isEmptySpace(world.m_8055_(attemptPos.m_5487_(axis, 1).m_6630_(2))) && this.canHoldPortal(world, attemptPos.m_7495_()) && this.canHoldPortal(world, attemptPos.m_5487_(axis, 1).m_7495_())) {
            return attemptPos;
        }
        return null;
    }

    protected boolean isEmptySpace(BlockState blockState) {
        return blockState.m_247087_() && !blockState.m_278721_();
    }

    protected boolean canHoldPortal(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_280296_() && blockState.m_60796_((BlockGetter)world, pos) && !this.isEmptySpace(blockState);
    }

    @Override
    public Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle arg, Entity entity, Direction.Axis portalAxis) {
        EntityDimensions entityDimensions = entity.m_6972_(entity.m_20089_());
        double width = (float)arg.f_124349_ - entityDimensions.f_20377_;
        double height = (float)arg.f_124350_ - entityDimensions.f_20378_;
        double deltaX = Mth.m_14112_((double)entity.m_20185_(), (double)arg.f_124348_.m_123341_(), (double)((double)arg.f_124348_.m_123341_() + width));
        double deltaY = Mth.m_14112_((double)entity.m_20186_(), (double)arg.f_124348_.m_123342_(), (double)((double)arg.f_124348_.m_123342_() + height));
        double deltaZ = Mth.m_14112_((double)entity.m_20189_(), (double)arg.f_124348_.m_123343_(), (double)((double)arg.f_124348_.m_123343_() + width));
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    @Override
    public PortalInfo getTPTargetInPortal(BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 prevOffset, Entity entity) {
        EntityDimensions entityDimensions = entity.m_6972_(entity.m_20089_());
        double width = (float)portalRect.f_124349_ - entityDimensions.f_20377_;
        double height = (float)portalRect.f_124350_ - entityDimensions.f_20378_;
        double x = Mth.m_14139_((double)prevOffset.f_82479_, (double)portalRect.f_124348_.m_123341_(), (double)((double)portalRect.f_124348_.m_123341_() + width));
        double y = Mth.m_14139_((double)prevOffset.f_82480_, (double)portalRect.f_124348_.m_123342_(), (double)((double)portalRect.f_124348_.m_123342_() + height));
        double z = Mth.m_14139_((double)prevOffset.f_82481_, (double)portalRect.f_124348_.m_123343_(), (double)((double)portalRect.f_124348_.m_123343_() + width));
        if (portalAxis == Direction.Axis.X) {
            z = (double)portalRect.f_124348_.m_123343_() + 0.5;
        } else if (portalAxis == Direction.Axis.Z) {
            x = (double)portalRect.f_124348_.m_123341_() + 0.5;
        }
        return new PortalInfo(new Vec3(x, y, z), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
    }

    @Override
    public void lightPortal(Block frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        BlockState blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().m_49966_() : CustomPortalsMod.getDefaultPortalBlock().m_49966_(), this.axis);
        BlockPos.m_121940_((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.m_5484_(Direction.UP, this.height - 1).m_5487_(this.axis, this.width - 1)).forEach(blockPos -> this.world.m_7731_(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(Level world, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        Direction.Axis rotatedAxis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        for (i = -1; i < 4; ++i) {
            world.m_46597_(pos.m_6630_(i).m_5487_(axis, -1), frameBlock);
            world.m_46597_(pos.m_6630_(i).m_5487_(axis, 2), frameBlock);
            if (i < 0) continue;
            this.fillAirAroundPortal(world, pos.m_6630_(i).m_5487_(axis, -1).m_5487_(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.m_6630_(i).m_5487_(axis, 2).m_5487_(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.m_6630_(i).m_5487_(axis, -1).m_5487_(rotatedAxis, -1));
            this.fillAirAroundPortal(world, pos.m_6630_(i).m_5487_(axis, 2).m_5487_(rotatedAxis, -1));
        }
        for (i = -1; i < 3; ++i) {
            world.m_46597_(pos.m_6630_(-1).m_5487_(axis, i), frameBlock);
            world.m_46597_(pos.m_6630_(3).m_5487_(axis, i), frameBlock);
            this.fillAirAroundPortal(world, pos.m_6630_(3).m_5487_(axis, i).m_5487_(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.m_6630_(3).m_5487_(axis, i).m_5487_(rotatedAxis, -1));
        }
        this.placeLandingPad(world, pos.m_7495_().m_5487_(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.m_7495_().m_5487_(rotatedAxis, -1), frameBlock);
        this.placeLandingPad(world, pos.m_7495_().m_5487_(axis, 1).m_5487_(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.m_7495_().m_5487_(axis, 1).m_5487_(rotatedAxis, -1), frameBlock);
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.fillAirAroundPortal(world, pos.m_5487_(axis, i).m_6630_(j).m_5487_(rotatedAxis, 1));
                this.fillAirAroundPortal(world, pos.m_5487_(axis, i).m_6630_(j).m_5487_(rotatedAxis, -1));
            }
        }
        this.lowerCorner = pos;
        this.width = 2;
        this.height = 3;
        this.axis = axis;
        this.world = world;
        this.foundPortalBlocks = 6;
        this.lightPortal(frameBlock.m_60734_());
    }

    protected void fillAirAroundPortal(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_280296_() || world.m_8055_(pos).m_60796_((BlockGetter)world, pos)) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    protected void placeLandingPad(Level world, BlockPos pos, BlockState frameBlock) {
        if (!world.m_8055_(pos).m_280296_()) {
            world.m_46597_(pos, frameBlock);
        }
    }
}

