/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.api;

import java.util.function.Consumer;
import java.util.function.Function;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.CPASoundEventData;
import net.kyrptonaught.customportalapi.util.ColorUtil;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.kyrptonaught.customportalapi.util.SHOULDTP;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;

public class CustomPortalBuilder {
    private final PortalLink portalLink = new PortalLink();

    private CustomPortalBuilder() {
    }

    public static CustomPortalBuilder beginPortal() {
        return new CustomPortalBuilder();
    }

    public void registerPortal() {
        CustomPortalApiRegistry.addPortal((Block)BuiltInRegistries.f_256975_.m_7745_(this.portalLink.block), this.portalLink);
    }

    public CustomPortalBuilder frameBlock(ResourceLocation blockID) {
        this.portalLink.block = blockID;
        return this;
    }

    public CustomPortalBuilder frameBlock(Block block) {
        this.portalLink.block = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return this;
    }

    public CustomPortalBuilder destDimID(ResourceLocation dimID) {
        this.portalLink.dimID = dimID;
        return this;
    }

    public CustomPortalBuilder tintColor(int color) {
        this.portalLink.colorID = color;
        return this;
    }

    public CustomPortalBuilder tintColor(int r, int g, int b) {
        this.portalLink.colorID = ColorUtil.getColorFromRGB(r, g, b);
        return this;
    }

    public CustomPortalBuilder lightWithWater() {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.WATER;
        return this;
    }

    public CustomPortalBuilder lightWithItem(Item item) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.ItemUseSource(item);
        return this;
    }

    public CustomPortalBuilder lightWithFluid(Fluid fluid) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.FluidSource(fluid);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(ResourceLocation customSourceID) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.CustomSource(customSourceID);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(PortalIgnitionSource ignitionSource) {
        this.portalLink.portalIgnitionSource = ignitionSource;
        return this;
    }

    public CustomPortalBuilder forcedSize(int width, int height) {
        this.portalLink.forcedWidth = width;
        this.portalLink.forcedHeight = height;
        return this;
    }

    public CustomPortalBuilder customPortalBlock(RegistryObject<CustomPortalBlock> portalBlock) {
        this.portalLink.setPortalBlock(portalBlock);
        return this;
    }

    public CustomPortalBuilder returnDim(ResourceLocation returnDimID, boolean onlyIgnitableInReturnDim) {
        this.portalLink.returnDimID = returnDimID;
        this.portalLink.onlyIgnitableInReturnDim = onlyIgnitableInReturnDim;
        return this;
    }

    public CustomPortalBuilder onlyLightInOverworld() {
        this.portalLink.onlyIgnitableInReturnDim = true;
        return this;
    }

    public CustomPortalBuilder flatPortal() {
        this.portalLink.portalFrameTester = CustomPortalsMod.FLATPORTAL_FRAMETESTER;
        return this;
    }

    public CustomPortalBuilder customFrameTester(ResourceLocation frameTester) {
        this.portalLink.portalFrameTester = frameTester;
        return this;
    }

    public CustomPortalBuilder registerBeforeTPEvent(Function<Entity, SHOULDTP> event) {
        this.portalLink.getBeforeTPEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerInPortalAmbienceSound(Function<Player, CPASoundEventData> event) {
        this.portalLink.getInPortalAmbienceEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerPostTPPortalAmbience(Function<Player, CPASoundEventData> event) {
        this.portalLink.getPostTpPortalAmbienceEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerPostTPEvent(Consumer<Entity> event) {
        this.portalLink.setPostTPEvent(event);
        return this;
    }
}

